% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_type_prob.R
\name{get_param_dist}
\alias{get_param_dist}
\title{Get a distribution of model parameters}
\usage{
get_param_dist(model, using, n_draws = 4000)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by \code{\link{make_model}}.}

\item{using}{A character string. Indicates whether to use `priors`, `posteriors` or `parameters`.}

\item{n_draws}{An integer. If no prior distribution is provided, generate prior distribution with \code{n_draws} number of draws.}
}
\value{
A \code{matrix} with the distribution of the parameters in the model
}
\description{
Using parameters, priors, or posteriors
}
\examples{
get_param_dist(model = make_model('X->Y'), using = 'priors', n_draws = 4)
get_param_dist(model = make_model('X->Y'), using = 'parameters')
}
