% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parmap.R
\name{make_parmap}
\alias{make_parmap}
\title{Make parmap: a matrix mapping from parameters to data types}
\usage{
make_parmap(model, A = NULL, P = NULL)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by
\code{\link{make_model}}.}

\item{A}{A \code{data.frame}. Ambiguity matrix. Not required but may be
provided to avoid repeated computation for simulations.}

\item{P}{A \code{data.frame}. Parameter matrix. Not required but may be
provided to avoid repeated computation for simulations.}
}
\value{
A matrix
}
\description{
Generates a matrix with a row per parameter and a column per data type.
}
\examples{
make_parmap(model = make_model('X->Y'))
make_parmap(model = make_model('X->Y; X<->Y'))
make_parmap(model = make_model('X->Y; X<->Y')) |> attr("map")
make_parmap(model = make_model('X -> M -> Y; X <-> Y'))
make_parmap(model = make_model('X -> M -> Y; M <-> Y'))
model <- make_model('X -> M -> Y; M <-> Y; X <-> M')
make_parmap(model)
make_parmap(model) |> attr("map")
# Any ways (without paths splits)
make_parmap(model) \%*\% (make_parmap(model) |> attr("map"))

\dontrun{
# X1 and X2 are confounded and jointly determine Y1, Y2.
# For instance for models in which X and Y take on four values rather than 2.
model <- make_model("Y2 <- X1 -> Y1; Y2 <- X2 ->Y1; X1 <-> X2; Y1 <-> Y2")
parmap <- make_parmap(model)
parmap |> dim()

CausalQueries:::prep_stan_data(
  model,
  CausalQueries:::minimal_event_data(model))$n_params
}
}
