// Generated by rstantools.  Do not edit by hand.

/*
    CausalQueries is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    CausalQueries is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with CausalQueries.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_simplexes_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'simplexes', line 33, column 0 to column 47)",
                                                      " (in 'simplexes', line 36, column 0 to column 43)",
                                                      " (in 'simplexes', line 37, column 0 to column 41)",
                                                      " (in 'simplexes', line 38, column 0 to column 33)",
                                                      " (in 'simplexes', line 39, column 0 to column 33)",
                                                      " (in 'simplexes', line 40, column 0 to column 38)",
                                                      " (in 'simplexes', line 41, column 0 to column 35)",
                                                      " (in 'simplexes', line 42, column 0 to column 42)",
                                                      " (in 'simplexes', line 52, column 4 to line 53, column 58)",
                                                      " (in 'simplexes', line 54, column 4 to line 56, column 20)",
                                                      " (in 'simplexes', line 51, column 36 to line 57, column 5)",
                                                      " (in 'simplexes', line 51, column 7 to line 57, column 5)",
                                                      " (in 'simplexes', line 47, column 4 to column 22)",
                                                      " (in 'simplexes', line 49, column 4 to column 61)",
                                                      " (in 'simplexes', line 46, column 32 to line 50, column 5)",
                                                      " (in 'simplexes', line 46, column 2 to line 57, column 5)",
                                                      " (in 'simplexes', line 45, column 26 to line 58, column 3)",
                                                      " (in 'simplexes', line 45, column 0 to line 58, column 3)",
                                                      " (in 'simplexes', line 61, column 0 to column 49)",
                                                      " (in 'simplexes', line 64, column 1 to column 66)",
                                                      " (in 'simplexes', line 63, column 21 to line 65, column 2)",
                                                      " (in 'simplexes', line 63, column 0 to line 65, column 2)",
                                                      " (in 'simplexes', line 68, column 2 to column 29)",
                                                      " (in 'simplexes', line 67, column 21 to line 69, column 2)",
                                                      " (in 'simplexes', line 67, column 0 to line 69, column 2)",
                                                      " (in 'simplexes', line 71, column 1 to column 14)",
                                                      " (in 'simplexes', line 73, column 1 to column 16)",
                                                      " (in 'simplexes', line 93, column 0 to column 30)",
                                                      " (in 'simplexes', line 96, column 3 to column 56)",
                                                      " (in 'simplexes', line 95, column 21 to line 97, column 1)",
                                                      " (in 'simplexes', line 95, column 0 to line 97, column 1)",
                                                      " (in 'simplexes', line 94, column 26 to line 97, column 2)",
                                                      " (in 'simplexes', line 94, column 0 to line 97, column 2)",
                                                      " (in 'simplexes', line 99, column 4 to column 43)",
                                                      " (in 'simplexes', line 98, column 27 to line 100, column 2)",
                                                      " (in 'simplexes', line 98, column 1 to line 100, column 2)",
                                                      " (in 'simplexes', line 78, column 2 to line 79, column 43)",
                                                      " (in 'simplexes', line 80, column 2 to column 50)",
                                                      " (in 'simplexes', line 77, column 26 to line 81, column 2)",
                                                      " (in 'simplexes', line 77, column 0 to line 81, column 2)",
                                                      " (in 'simplexes', line 85, column 2 to line 88, column 55)",
                                                      " (in 'simplexes', line 84, column 26 to line 89, column 2)",
                                                      " (in 'simplexes', line 84, column 0 to line 89, column 2)",
                                                      " (in 'simplexes', line 9, column 0 to column 22)",
                                                      " (in 'simplexes', line 10, column 0 to column 21)",
                                                      " (in 'simplexes', line 11, column 0 to column 21)",
                                                      " (in 'simplexes', line 12, column 0 to column 26)",
                                                      " (in 'simplexes', line 13, column 0 to column 21)",
                                                      " (in 'simplexes', line 14, column 6 to column 18)",
                                                      " (in 'simplexes', line 14, column 0 to column 46)",
                                                      " (in 'simplexes', line 15, column 0 to column 20)",
                                                      " (in 'simplexes', line 16, column 0 to column 22)",
                                                      " (in 'simplexes', line 17, column 0 to column 26)",
                                                      " (in 'simplexes', line 18, column 0 to column 39)",
                                                      " (in 'simplexes', line 19, column 16 to column 24)",
                                                      " (in 'simplexes', line 19, column 0 to column 40)",
                                                      " (in 'simplexes', line 20, column 6 to column 18)",
                                                      " (in 'simplexes', line 20, column 0 to column 42)",
                                                      " (in 'simplexes', line 21, column 6 to column 18)",
                                                      " (in 'simplexes', line 21, column 0 to column 40)",
                                                      " (in 'simplexes', line 22, column 6 to column 13)",
                                                      " (in 'simplexes', line 22, column 0 to column 40)",
                                                      " (in 'simplexes', line 23, column 6 to column 13)",
                                                      " (in 'simplexes', line 23, column 0 to column 38)",
                                                      " (in 'simplexes', line 24, column 6 to column 18)",
                                                      " (in 'simplexes', line 24, column 0 to column 49)",
                                                      " (in 'simplexes', line 25, column 6 to column 18)",
                                                      " (in 'simplexes', line 25, column 0 to column 47)",
                                                      " (in 'simplexes', line 26, column 7 to column 15)",
                                                      " (in 'simplexes', line 26, column 17 to column 24)",
                                                      " (in 'simplexes', line 26, column 0 to column 28)",
                                                      " (in 'simplexes', line 27, column 7 to column 15)",
                                                      " (in 'simplexes', line 27, column 17 to column 24)",
                                                      " (in 'simplexes', line 27, column 0 to column 33)",
                                                      " (in 'simplexes', line 28, column 7 to column 14)",
                                                      " (in 'simplexes', line 28, column 16 to column 22)",
                                                      " (in 'simplexes', line 28, column 0 to column 28)",
                                                      " (in 'simplexes', line 29, column 24 to column 32)",
                                                      " (in 'simplexes', line 29, column 33 to column 39)",
                                                      " (in 'simplexes', line 29, column 0 to column 43)",
                                                      " (in 'simplexes', line 30, column 6 to column 14)",
                                                      " (in 'simplexes', line 30, column 0 to column 31)",
                                                      " (in 'simplexes', line 33, column 16 to column 39)",
                                                      " (in 'simplexes', line 36, column 25 to column 33)",
                                                      " (in 'simplexes', line 37, column 16 to column 28)",
                                                      " (in 'simplexes', line 38, column 7 to column 15)",
                                                      " (in 'simplexes', line 38, column 17 to column 24)",
                                                      " (in 'simplexes', line 39, column 7 to column 14)",
                                                      " (in 'simplexes', line 39, column 16 to column 23)",
                                                      " (in 'simplexes', line 40, column 25 to column 32)",
                                                      " (in 'simplexes', line 41, column 25 to column 31)",
                                                      " (in 'simplexes', line 42, column 25 to column 33)",
                                                      " (in 'simplexes', line 93, column 7 to column 14)",
                                                      " (in 'simplexes', line 3, column 15 to column 22)",
                                                      " (in 'simplexes', line 3, column 4 to column 27)",
                                                      " (in 'simplexes', line 4, column 4 to column 40)",
                                                      " (in 'simplexes', line 5, column 4 to column 14)",
                                                      " (in 'simplexes', line 2, column 32 to line 6, column 3)"};
template <typename T0__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>>, 1, -1>
col_sums(const T0__& X_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>>;
  const auto& X = to_ref(X_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 94;
    validate_non_negative_index("s", "cols(X)", cols(X));
    Eigen::Matrix<local_scalar_t__, 1, -1> s;
    s = Eigen::Matrix<local_scalar_t__, 1, -1>(cols(X));
    stan::math::fill(s, DUMMY_VAR__);
    
    current_statement__ = 96;
    assign(s, nil_index_list(), multiply(rep_row_vector(1, rows(X)), X),
      "assigning variable s");
    current_statement__ = 97;
    return s;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct col_sums_functor__ {
template <typename T0__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>>, 1, -1>
operator()(const T0__& X, std::ostream* pstream__)  const 
{
return col_sums(X, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_simplexes final : public model_base_crtp<model_simplexes> {
private:
  int n_params;
  int n_paths;
  int n_types;
  int n_param_sets;
  int n_nodes;
  std::vector<int> n_param_each;
  int n_data;
  int n_events;
  int n_strategies;
  int keep_transformed;
  Eigen::Matrix<double, -1, 1> lambdas_prior;
  std::vector<int> l_starts;
  std::vector<int> l_ends;
  std::vector<int> node_starts;
  std::vector<int> node_ends;
  std::vector<int> strategy_starts;
  std::vector<int> strategy_ends;
  Eigen::Matrix<double, -1, -1> P;
  Eigen::Matrix<double, -1, -1> parmap;
  Eigen::Matrix<double, -1, -1> map;
  Eigen::Matrix<double, -1, -1> E;
  std::vector<int> Y;
  int gamma_1dim__;
 
public:
  ~model_simplexes() { }
  
  inline std::string model_name() const final { return "model_simplexes"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_simplexes(stan::io::var_context& context__,
                  unsigned int random_seed__ = 0,
                  std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_simplexes_namespace::model_simplexes";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 44;
      context__.validate_dims("data initialization","n_params","int",
          context__.to_vec());
      n_params = std::numeric_limits<int>::min();
      
      current_statement__ = 44;
      n_params = context__.vals_i("n_params")[(1 - 1)];
      current_statement__ = 44;
      current_statement__ = 44;
      check_greater_or_equal(function__, "n_params", n_params, 1);
      current_statement__ = 45;
      context__.validate_dims("data initialization","n_paths","int",
          context__.to_vec());
      n_paths = std::numeric_limits<int>::min();
      
      current_statement__ = 45;
      n_paths = context__.vals_i("n_paths")[(1 - 1)];
      current_statement__ = 45;
      current_statement__ = 45;
      check_greater_or_equal(function__, "n_paths", n_paths, 1);
      current_statement__ = 46;
      context__.validate_dims("data initialization","n_types","int",
          context__.to_vec());
      n_types = std::numeric_limits<int>::min();
      
      current_statement__ = 46;
      n_types = context__.vals_i("n_types")[(1 - 1)];
      current_statement__ = 46;
      current_statement__ = 46;
      check_greater_or_equal(function__, "n_types", n_types, 1);
      current_statement__ = 47;
      context__.validate_dims("data initialization","n_param_sets","int",
          context__.to_vec());
      n_param_sets = std::numeric_limits<int>::min();
      
      current_statement__ = 47;
      n_param_sets = context__.vals_i("n_param_sets")[(1 - 1)];
      current_statement__ = 47;
      current_statement__ = 47;
      check_greater_or_equal(function__, "n_param_sets", n_param_sets, 1);
      current_statement__ = 48;
      context__.validate_dims("data initialization","n_nodes","int",
          context__.to_vec());
      n_nodes = std::numeric_limits<int>::min();
      
      current_statement__ = 48;
      n_nodes = context__.vals_i("n_nodes")[(1 - 1)];
      current_statement__ = 48;
      current_statement__ = 48;
      check_greater_or_equal(function__, "n_nodes", n_nodes, 1);
      current_statement__ = 49;
      validate_non_negative_index("n_param_each", "n_param_sets",
                                  n_param_sets);
      current_statement__ = 50;
      context__.validate_dims("data initialization","n_param_each","int",
          context__.to_vec(n_param_sets));
      n_param_each = std::vector<int>(n_param_sets, std::numeric_limits<int>::min());
      
      current_statement__ = 50;
      assign(n_param_each, nil_index_list(),
        context__.vals_i("n_param_each"), "assigning variable n_param_each");
      current_statement__ = 50;
      for (int sym1__ = 1; sym1__ <= n_param_sets; ++sym1__) {
        current_statement__ = 50;
        current_statement__ = 50;
        check_greater_or_equal(function__, "n_param_each[sym1__]",
                               n_param_each[(sym1__ - 1)], 1);}
      current_statement__ = 51;
      context__.validate_dims("data initialization","n_data","int",
          context__.to_vec());
      n_data = std::numeric_limits<int>::min();
      
      current_statement__ = 51;
      n_data = context__.vals_i("n_data")[(1 - 1)];
      current_statement__ = 51;
      current_statement__ = 51;
      check_greater_or_equal(function__, "n_data", n_data, 1);
      current_statement__ = 52;
      context__.validate_dims("data initialization","n_events","int",
          context__.to_vec());
      n_events = std::numeric_limits<int>::min();
      
      current_statement__ = 52;
      n_events = context__.vals_i("n_events")[(1 - 1)];
      current_statement__ = 52;
      current_statement__ = 52;
      check_greater_or_equal(function__, "n_events", n_events, 1);
      current_statement__ = 53;
      context__.validate_dims("data initialization","n_strategies","int",
          context__.to_vec());
      n_strategies = std::numeric_limits<int>::min();
      
      current_statement__ = 53;
      n_strategies = context__.vals_i("n_strategies")[(1 - 1)];
      current_statement__ = 53;
      current_statement__ = 53;
      check_greater_or_equal(function__, "n_strategies", n_strategies, 1);
      current_statement__ = 54;
      context__.validate_dims("data initialization","keep_transformed","int",
          context__.to_vec());
      keep_transformed = std::numeric_limits<int>::min();
      
      current_statement__ = 54;
      keep_transformed = context__.vals_i("keep_transformed")[(1 - 1)];
      current_statement__ = 54;
      current_statement__ = 54;
      check_greater_or_equal(function__, "keep_transformed",
                             keep_transformed, 0);
      current_statement__ = 54;
      current_statement__ = 54;
      check_less_or_equal(function__, "keep_transformed", keep_transformed, 1);
      current_statement__ = 55;
      validate_non_negative_index("lambdas_prior", "n_params", n_params);
      current_statement__ = 56;
      context__.validate_dims("data initialization","lambdas_prior","double",
          context__.to_vec(n_params));
      lambdas_prior = Eigen::Matrix<double, -1, 1>(n_params);
      stan::math::fill(lambdas_prior, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> lambdas_prior_flat__;
        current_statement__ = 56;
        assign(lambdas_prior_flat__, nil_index_list(),
          context__.vals_r("lambdas_prior"),
          "assigning variable lambdas_prior_flat__");
        current_statement__ = 56;
        pos__ = 1;
        current_statement__ = 56;
        for (int sym1__ = 1; sym1__ <= n_params; ++sym1__) {
          current_statement__ = 56;
          assign(lambdas_prior,
            cons_list(index_uni(sym1__), nil_index_list()),
            lambdas_prior_flat__[(pos__ - 1)],
            "assigning variable lambdas_prior");
          current_statement__ = 56;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 56;
      for (int sym1__ = 1; sym1__ <= n_params; ++sym1__) {
        current_statement__ = 56;
        current_statement__ = 56;
        check_greater_or_equal(function__, "lambdas_prior[sym1__]",
                               lambdas_prior[(sym1__ - 1)], 0);}
      current_statement__ = 57;
      validate_non_negative_index("l_starts", "n_param_sets", n_param_sets);
      current_statement__ = 58;
      context__.validate_dims("data initialization","l_starts","int",
          context__.to_vec(n_param_sets));
      l_starts = std::vector<int>(n_param_sets, std::numeric_limits<int>::min());
      
      current_statement__ = 58;
      assign(l_starts, nil_index_list(), context__.vals_i("l_starts"),
        "assigning variable l_starts");
      current_statement__ = 58;
      for (int sym1__ = 1; sym1__ <= n_param_sets; ++sym1__) {
        current_statement__ = 58;
        current_statement__ = 58;
        check_greater_or_equal(function__, "l_starts[sym1__]",
                               l_starts[(sym1__ - 1)], 1);}
      current_statement__ = 59;
      validate_non_negative_index("l_ends", "n_param_sets", n_param_sets);
      current_statement__ = 60;
      context__.validate_dims("data initialization","l_ends","int",
          context__.to_vec(n_param_sets));
      l_ends = std::vector<int>(n_param_sets, std::numeric_limits<int>::min());
      
      current_statement__ = 60;
      assign(l_ends, nil_index_list(), context__.vals_i("l_ends"),
        "assigning variable l_ends");
      current_statement__ = 60;
      for (int sym1__ = 1; sym1__ <= n_param_sets; ++sym1__) {
        current_statement__ = 60;
        current_statement__ = 60;
        check_greater_or_equal(function__, "l_ends[sym1__]",
                               l_ends[(sym1__ - 1)], 1);}
      current_statement__ = 61;
      validate_non_negative_index("node_starts", "n_nodes", n_nodes);
      current_statement__ = 62;
      context__.validate_dims("data initialization","node_starts","int",
          context__.to_vec(n_nodes));
      node_starts = std::vector<int>(n_nodes, std::numeric_limits<int>::min());
      
      current_statement__ = 62;
      assign(node_starts, nil_index_list(), context__.vals_i("node_starts"),
        "assigning variable node_starts");
      current_statement__ = 62;
      for (int sym1__ = 1; sym1__ <= n_nodes; ++sym1__) {
        current_statement__ = 62;
        current_statement__ = 62;
        check_greater_or_equal(function__, "node_starts[sym1__]",
                               node_starts[(sym1__ - 1)], 1);}
      current_statement__ = 63;
      validate_non_negative_index("node_ends", "n_nodes", n_nodes);
      current_statement__ = 64;
      context__.validate_dims("data initialization","node_ends","int",
          context__.to_vec(n_nodes));
      node_ends = std::vector<int>(n_nodes, std::numeric_limits<int>::min());
      
      current_statement__ = 64;
      assign(node_ends, nil_index_list(), context__.vals_i("node_ends"),
        "assigning variable node_ends");
      current_statement__ = 64;
      for (int sym1__ = 1; sym1__ <= n_nodes; ++sym1__) {
        current_statement__ = 64;
        current_statement__ = 64;
        check_greater_or_equal(function__, "node_ends[sym1__]",
                               node_ends[(sym1__ - 1)], 1);}
      current_statement__ = 65;
      validate_non_negative_index("strategy_starts", "n_strategies",
                                  n_strategies);
      current_statement__ = 66;
      context__.validate_dims("data initialization","strategy_starts","int",
          context__.to_vec(n_strategies));
      strategy_starts = std::vector<int>(n_strategies, std::numeric_limits<int>::min());
      
      current_statement__ = 66;
      assign(strategy_starts, nil_index_list(),
        context__.vals_i("strategy_starts"),
        "assigning variable strategy_starts");
      current_statement__ = 66;
      for (int sym1__ = 1; sym1__ <= n_strategies; ++sym1__) {
        current_statement__ = 66;
        current_statement__ = 66;
        check_greater_or_equal(function__, "strategy_starts[sym1__]",
                               strategy_starts[(sym1__ - 1)], 1);}
      current_statement__ = 67;
      validate_non_negative_index("strategy_ends", "n_strategies",
                                  n_strategies);
      current_statement__ = 68;
      context__.validate_dims("data initialization","strategy_ends","int",
          context__.to_vec(n_strategies));
      strategy_ends = std::vector<int>(n_strategies, std::numeric_limits<int>::min());
      
      current_statement__ = 68;
      assign(strategy_ends, nil_index_list(),
        context__.vals_i("strategy_ends"), "assigning variable strategy_ends");
      current_statement__ = 68;
      for (int sym1__ = 1; sym1__ <= n_strategies; ++sym1__) {
        current_statement__ = 68;
        current_statement__ = 68;
        check_greater_or_equal(function__, "strategy_ends[sym1__]",
                               strategy_ends[(sym1__ - 1)], 1);}
      current_statement__ = 69;
      validate_non_negative_index("P", "n_params", n_params);
      current_statement__ = 70;
      validate_non_negative_index("P", "n_types", n_types);
      current_statement__ = 71;
      context__.validate_dims("data initialization","P","double",
          context__.to_vec(n_params, n_types));
      P = Eigen::Matrix<double, -1, -1>(n_params, n_types);
      stan::math::fill(P, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> P_flat__;
        current_statement__ = 71;
        assign(P_flat__, nil_index_list(), context__.vals_r("P"),
          "assigning variable P_flat__");
        current_statement__ = 71;
        pos__ = 1;
        current_statement__ = 71;
        for (int sym1__ = 1; sym1__ <= n_types; ++sym1__) {
          current_statement__ = 71;
          for (int sym2__ = 1; sym2__ <= n_params; ++sym2__) {
            current_statement__ = 71;
            assign(P,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              P_flat__[(pos__ - 1)], "assigning variable P");
            current_statement__ = 71;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 72;
      validate_non_negative_index("parmap", "n_params", n_params);
      current_statement__ = 73;
      validate_non_negative_index("parmap", "n_paths", n_paths);
      current_statement__ = 74;
      context__.validate_dims("data initialization","parmap","double",
          context__.to_vec(n_params, n_paths));
      parmap = Eigen::Matrix<double, -1, -1>(n_params, n_paths);
      stan::math::fill(parmap, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> parmap_flat__;
        current_statement__ = 74;
        assign(parmap_flat__, nil_index_list(), context__.vals_r("parmap"),
          "assigning variable parmap_flat__");
        current_statement__ = 74;
        pos__ = 1;
        current_statement__ = 74;
        for (int sym1__ = 1; sym1__ <= n_paths; ++sym1__) {
          current_statement__ = 74;
          for (int sym2__ = 1; sym2__ <= n_params; ++sym2__) {
            current_statement__ = 74;
            assign(parmap,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              parmap_flat__[(pos__ - 1)], "assigning variable parmap");
            current_statement__ = 74;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 75;
      validate_non_negative_index("map", "n_paths", n_paths);
      current_statement__ = 76;
      validate_non_negative_index("map", "n_data", n_data);
      current_statement__ = 77;
      context__.validate_dims("data initialization","map","double",
          context__.to_vec(n_paths, n_data));
      map = Eigen::Matrix<double, -1, -1>(n_paths, n_data);
      stan::math::fill(map, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> map_flat__;
        current_statement__ = 77;
        assign(map_flat__, nil_index_list(), context__.vals_r("map"),
          "assigning variable map_flat__");
        current_statement__ = 77;
        pos__ = 1;
        current_statement__ = 77;
        for (int sym1__ = 1; sym1__ <= n_data; ++sym1__) {
          current_statement__ = 77;
          for (int sym2__ = 1; sym2__ <= n_paths; ++sym2__) {
            current_statement__ = 77;
            assign(map,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              map_flat__[(pos__ - 1)], "assigning variable map");
            current_statement__ = 77;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 78;
      validate_non_negative_index("E", "n_events", n_events);
      current_statement__ = 79;
      validate_non_negative_index("E", "n_data", n_data);
      current_statement__ = 80;
      context__.validate_dims("data initialization","E","double",
          context__.to_vec(n_events, n_data));
      E = Eigen::Matrix<double, -1, -1>(n_events, n_data);
      stan::math::fill(E, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> E_flat__;
        current_statement__ = 80;
        assign(E_flat__, nil_index_list(), context__.vals_r("E"),
          "assigning variable E_flat__");
        current_statement__ = 80;
        pos__ = 1;
        current_statement__ = 80;
        for (int sym1__ = 1; sym1__ <= n_data; ++sym1__) {
          current_statement__ = 80;
          for (int sym2__ = 1; sym2__ <= n_events; ++sym2__) {
            current_statement__ = 80;
            assign(E,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              E_flat__[(pos__ - 1)], "assigning variable E");
            current_statement__ = 80;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 80;
      for (int sym1__ = 1; sym1__ <= n_events; ++sym1__) {
        current_statement__ = 80;
        for (int sym2__ = 1; sym2__ <= n_data; ++sym2__) {
          current_statement__ = 80;
          current_statement__ = 80;
          check_greater_or_equal(function__, "E[sym1__, sym2__]",
                                 rvalue(E,
                                   cons_list(index_uni(sym1__),
                                     cons_list(index_uni(sym2__),
                                       nil_index_list())), "E"), 0);}}
      current_statement__ = 80;
      for (int sym1__ = 1; sym1__ <= n_events; ++sym1__) {
        current_statement__ = 80;
        for (int sym2__ = 1; sym2__ <= n_data; ++sym2__) {
          current_statement__ = 80;
          current_statement__ = 80;
          check_less_or_equal(function__, "E[sym1__, sym2__]",
                              rvalue(E,
                                cons_list(index_uni(sym1__),
                                  cons_list(index_uni(sym2__),
                                    nil_index_list())), "E"), 1);}}
      current_statement__ = 81;
      validate_non_negative_index("Y", "n_events", n_events);
      current_statement__ = 82;
      context__.validate_dims("data initialization","Y","int",
          context__.to_vec(n_events));
      Y = std::vector<int>(n_events, std::numeric_limits<int>::min());
      
      current_statement__ = 82;
      assign(Y, nil_index_list(), context__.vals_i("Y"),
        "assigning variable Y");
      current_statement__ = 82;
      for (int sym1__ = 1; sym1__ <= n_events; ++sym1__) {
        current_statement__ = 82;
        current_statement__ = 82;
        check_greater_or_equal(function__, "Y[sym1__]", Y[(sym1__ - 1)], 0);}
      current_statement__ = 83;
      gamma_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 83;
      gamma_1dim__ = (n_params - n_param_sets);
      current_statement__ = 83;
      validate_non_negative_index("gamma", "n_params - n_param_sets",
                                  gamma_1dim__);
      current_statement__ = 84;
      validate_non_negative_index("lambdas", "n_params", n_params);
      current_statement__ = 85;
      validate_non_negative_index("sum_gammas", "n_param_sets", n_param_sets);
      current_statement__ = 86;
      validate_non_negative_index("parlam", "n_params", n_params);
      current_statement__ = 87;
      validate_non_negative_index("parlam", "n_paths", n_paths);
      current_statement__ = 88;
      validate_non_negative_index("parlam2", "n_nodes", n_nodes);
      current_statement__ = 89;
      validate_non_negative_index("parlam2", "n_paths", n_paths);
      current_statement__ = 90;
      validate_non_negative_index("w_0", "n_paths", n_paths);
      current_statement__ = 91;
      validate_non_negative_index("w", "n_data", n_data);
      current_statement__ = 92;
      validate_non_negative_index("w_full", "n_events", n_events);
      current_statement__ = 93;
      validate_non_negative_index("prob_of_types", "n_types", n_types);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += gamma_1dim__;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_simplexes_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> gamma;
      gamma = Eigen::Matrix<local_scalar_t__, -1, 1>(gamma_1dim__);
      stan::math::fill(gamma, DUMMY_VAR__);
      
      current_statement__ = 1;
      gamma = in__.vector(gamma_1dim__);
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
        current_statement__ = 1;
        if (jacobian__) {
          current_statement__ = 1;
          assign(gamma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(gamma[(sym1__ - 1)], 0, lp__),
            "assigning variable gamma");
        } else {
          current_statement__ = 1;
          assign(gamma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(gamma[(sym1__ - 1)], 0),
            "assigning variable gamma");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> lambdas;
      lambdas = Eigen::Matrix<local_scalar_t__, -1, 1>(n_params);
      stan::math::fill(lambdas, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> sum_gammas;
      sum_gammas = Eigen::Matrix<local_scalar_t__, -1, 1>(n_param_sets);
      stan::math::fill(sum_gammas, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, -1> parlam;
      parlam = Eigen::Matrix<local_scalar_t__, -1, -1>(n_params, n_paths);
      stan::math::fill(parlam, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, -1> parlam2;
      parlam2 = Eigen::Matrix<local_scalar_t__, -1, -1>(n_nodes, n_paths);
      stan::math::fill(parlam2, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> w_0;
      w_0 = Eigen::Matrix<local_scalar_t__, -1, 1>(n_paths);
      stan::math::fill(w_0, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> w;
      w = Eigen::Matrix<local_scalar_t__, -1, 1>(n_data);
      stan::math::fill(w, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> w_full;
      w_full = Eigen::Matrix<local_scalar_t__, -1, 1>(n_events);
      stan::math::fill(w_full, DUMMY_VAR__);
      
      current_statement__ = 18;
      for (int i = 1; i <= n_param_sets; ++i) {
        current_statement__ = 16;
        if (logical_gte(l_starts[(i - 1)], l_ends[(i - 1)])) {
          current_statement__ = 13;
          assign(sum_gammas, cons_list(index_uni(i), nil_index_list()), 1,
            "assigning variable sum_gammas");
          current_statement__ = 14;
          assign(lambdas,
            cons_list(index_uni(l_starts[(i - 1)]), nil_index_list()),
            (lambdas_prior[(1 - 1)] / lambdas_prior[(1 - 1)]),
            "assigning variable lambdas");
        } else {
          current_statement__ = 12;
          if (logical_lt(l_starts[(i - 1)], l_ends[(i - 1)])) {
            current_statement__ = 9;
            assign(sum_gammas, cons_list(index_uni(i), nil_index_list()),
              (1 +
                sum(
                  rvalue(gamma,
                    cons_list(
                      index_min_max((l_starts[(i - 1)] - (i - 1)), (l_ends[
                                                                    (i - 1)]
                                                                    - i)),
                      nil_index_list()), "gamma"))),
              "assigning variable sum_gammas");
            current_statement__ = 10;
            assign(lambdas,
              cons_list(index_min_max(l_starts[(i - 1)], l_ends[(i - 1)]),
                nil_index_list()),
              divide(
                append_row(1,
                  rvalue(gamma,
                    cons_list(
                      index_min_max((l_starts[(i - 1)] - (i - 1)), (l_ends[
                                                                    (i - 1)]
                                                                    - i)),
                      nil_index_list()), "gamma")), sum_gammas[(i - 1)]),
              "assigning variable lambdas");
          } 
        }}
      current_statement__ = 19;
      assign(parlam, nil_index_list(),
        elt_multiply(rep_matrix(lambdas, n_paths), parmap),
        "assigning variable parlam");
      current_statement__ = 22;
      for (int i = 1; i <= n_nodes; ++i) {
        current_statement__ = 20;
        assign(parlam2,
          cons_list(index_uni(i), cons_list(index_omni(), nil_index_list())),
          col_sums(
            rvalue(parlam,
              cons_list(
                index_min_max(node_starts[(i - 1)], node_ends[(i - 1)]),
                cons_list(index_omni(), nil_index_list())), "parlam"), pstream__),
          "assigning variable parlam2");}
      current_statement__ = 25;
      for (int i = 1; i <= n_paths; ++i) {
        current_statement__ = 23;
        assign(w_0, cons_list(index_uni(i), nil_index_list()),
          prod(
            rvalue(parlam2,
              cons_list(index_omni(),
                cons_list(index_uni(i), nil_index_list())), "parlam2")),
          "assigning variable w_0");}
      current_statement__ = 26;
      assign(w, nil_index_list(), multiply(transpose(map), w_0),
        "assigning variable w");
      current_statement__ = 27;
      assign(w_full, nil_index_list(), multiply(E, w),
        "assigning variable w_full");
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= n_params; ++sym1__) {
        current_statement__ = 2;
        current_statement__ = 2;
        check_greater_or_equal(function__, "lambdas[sym1__]",
                               lambdas[(sym1__ - 1)], 0);}
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= n_params; ++sym1__) {
        current_statement__ = 2;
        current_statement__ = 2;
        check_less_or_equal(function__, "lambdas[sym1__]",
                            lambdas[(sym1__ - 1)], 1);}
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= n_param_sets; ++sym1__) {
        current_statement__ = 3;
        current_statement__ = 3;
        check_greater_or_equal(function__, "sum_gammas[sym1__]",
                               sum_gammas[(sym1__ - 1)], 1);}
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= n_paths; ++sym1__) {
        current_statement__ = 6;
        current_statement__ = 6;
        check_greater_or_equal(function__, "w_0[sym1__]", w_0[(sym1__ - 1)],
                               0);}
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= n_paths; ++sym1__) {
        current_statement__ = 6;
        current_statement__ = 6;
        check_less_or_equal(function__, "w_0[sym1__]", w_0[(sym1__ - 1)], 1);
      }
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= n_data; ++sym1__) {
        current_statement__ = 7;
        current_statement__ = 7;
        check_greater_or_equal(function__, "w[sym1__]", w[(sym1__ - 1)], 0);}
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= n_data; ++sym1__) {
        current_statement__ = 7;
        current_statement__ = 7;
        check_less_or_equal(function__, "w[sym1__]", w[(sym1__ - 1)], 1);}
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= n_events; ++sym1__) {
        current_statement__ = 8;
        current_statement__ = 8;
        check_greater_or_equal(function__, "w_full[sym1__]",
                               w_full[(sym1__ - 1)], 0);}
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= n_events; ++sym1__) {
        current_statement__ = 8;
        current_statement__ = 8;
        check_less_or_equal(function__, "w_full[sym1__]",
                            w_full[(sym1__ - 1)], 1);}
      {
        current_statement__ = 40;
        for (int i = 1; i <= n_param_sets; ++i) {
          current_statement__ = 37;
          lp_accum__.add(
            dirichlet_lpdf<false>(
              rvalue(lambdas,
                cons_list(index_min_max(l_starts[(i - 1)], l_ends[(i - 1)]),
                  nil_index_list()), "lambdas"),
              rvalue(lambdas_prior,
                cons_list(index_min_max(l_starts[(i - 1)], l_ends[(i - 1)]),
                  nil_index_list()), "lambdas_prior")));
          current_statement__ = 38;
          lp_accum__.add(
            (-n_param_each[(i - 1)] * stan::math::log(sum_gammas[(i - 1)])));
        }
        current_statement__ = 43;
        for (int i = 1; i <= n_strategies; ++i) {
          current_statement__ = 41;
          lp_accum__.add(
            multinomial_lpmf<false>(
              rvalue(Y,
                cons_list(
                  index_min_max(strategy_starts[(i - 1)], strategy_ends[
                  (i - 1)]), nil_index_list()), "Y"),
              divide(
                rvalue(w_full,
                  cons_list(
                    index_min_max(strategy_starts[(i - 1)], strategy_ends[
                    (i - 1)]), nil_index_list()), "w_full"),
                sum(
                  rvalue(w_full,
                    cons_list(
                      index_min_max(strategy_starts[(i - 1)], strategy_ends[
                      (i - 1)]), nil_index_list()), "w_full")))));}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_simplexes_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> gamma;
      gamma = Eigen::Matrix<double, -1, 1>(gamma_1dim__);
      stan::math::fill(gamma, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      gamma = in__.vector(gamma_1dim__);
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
        current_statement__ = 1;
        assign(gamma, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(gamma[(sym1__ - 1)], 0),
          "assigning variable gamma");}
      Eigen::Matrix<double, -1, 1> lambdas;
      lambdas = Eigen::Matrix<double, -1, 1>(n_params);
      stan::math::fill(lambdas, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> sum_gammas;
      sum_gammas = Eigen::Matrix<double, -1, 1>(n_param_sets);
      stan::math::fill(sum_gammas, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> parlam;
      parlam = Eigen::Matrix<double, -1, -1>(n_params, n_paths);
      stan::math::fill(parlam, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> parlam2;
      parlam2 = Eigen::Matrix<double, -1, -1>(n_nodes, n_paths);
      stan::math::fill(parlam2, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> w_0;
      w_0 = Eigen::Matrix<double, -1, 1>(n_paths);
      stan::math::fill(w_0, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> w;
      w = Eigen::Matrix<double, -1, 1>(n_data);
      stan::math::fill(w, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> w_full;
      w_full = Eigen::Matrix<double, -1, 1>(n_events);
      stan::math::fill(w_full, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
        vars__.emplace_back(gamma[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 18;
      for (int i = 1; i <= n_param_sets; ++i) {
        current_statement__ = 16;
        if (logical_gte(l_starts[(i - 1)], l_ends[(i - 1)])) {
          current_statement__ = 13;
          assign(sum_gammas, cons_list(index_uni(i), nil_index_list()), 1,
            "assigning variable sum_gammas");
          current_statement__ = 14;
          assign(lambdas,
            cons_list(index_uni(l_starts[(i - 1)]), nil_index_list()),
            (lambdas_prior[(1 - 1)] / lambdas_prior[(1 - 1)]),
            "assigning variable lambdas");
        } else {
          current_statement__ = 12;
          if (logical_lt(l_starts[(i - 1)], l_ends[(i - 1)])) {
            current_statement__ = 9;
            assign(sum_gammas, cons_list(index_uni(i), nil_index_list()),
              (1 +
                sum(
                  rvalue(gamma,
                    cons_list(
                      index_min_max((l_starts[(i - 1)] - (i - 1)), (l_ends[
                                                                    (i - 1)]
                                                                    - i)),
                      nil_index_list()), "gamma"))),
              "assigning variable sum_gammas");
            current_statement__ = 10;
            assign(lambdas,
              cons_list(index_min_max(l_starts[(i - 1)], l_ends[(i - 1)]),
                nil_index_list()),
              divide(
                append_row(1,
                  rvalue(gamma,
                    cons_list(
                      index_min_max((l_starts[(i - 1)] - (i - 1)), (l_ends[
                                                                    (i - 1)]
                                                                    - i)),
                      nil_index_list()), "gamma")), sum_gammas[(i - 1)]),
              "assigning variable lambdas");
          } 
        }}
      current_statement__ = 19;
      assign(parlam, nil_index_list(),
        elt_multiply(rep_matrix(lambdas, n_paths), parmap),
        "assigning variable parlam");
      current_statement__ = 22;
      for (int i = 1; i <= n_nodes; ++i) {
        current_statement__ = 20;
        assign(parlam2,
          cons_list(index_uni(i), cons_list(index_omni(), nil_index_list())),
          col_sums(
            rvalue(parlam,
              cons_list(
                index_min_max(node_starts[(i - 1)], node_ends[(i - 1)]),
                cons_list(index_omni(), nil_index_list())), "parlam"), pstream__),
          "assigning variable parlam2");}
      current_statement__ = 25;
      for (int i = 1; i <= n_paths; ++i) {
        current_statement__ = 23;
        assign(w_0, cons_list(index_uni(i), nil_index_list()),
          prod(
            rvalue(parlam2,
              cons_list(index_omni(),
                cons_list(index_uni(i), nil_index_list())), "parlam2")),
          "assigning variable w_0");}
      current_statement__ = 26;
      assign(w, nil_index_list(), multiply(transpose(map), w_0),
        "assigning variable w");
      current_statement__ = 27;
      assign(w_full, nil_index_list(), multiply(E, w),
        "assigning variable w_full");
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= n_params; ++sym1__) {
        current_statement__ = 2;
        current_statement__ = 2;
        check_greater_or_equal(function__, "lambdas[sym1__]",
                               lambdas[(sym1__ - 1)], 0);}
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= n_params; ++sym1__) {
        current_statement__ = 2;
        current_statement__ = 2;
        check_less_or_equal(function__, "lambdas[sym1__]",
                            lambdas[(sym1__ - 1)], 1);}
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= n_param_sets; ++sym1__) {
        current_statement__ = 3;
        current_statement__ = 3;
        check_greater_or_equal(function__, "sum_gammas[sym1__]",
                               sum_gammas[(sym1__ - 1)], 1);}
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= n_paths; ++sym1__) {
        current_statement__ = 6;
        current_statement__ = 6;
        check_greater_or_equal(function__, "w_0[sym1__]", w_0[(sym1__ - 1)],
                               0);}
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= n_paths; ++sym1__) {
        current_statement__ = 6;
        current_statement__ = 6;
        check_less_or_equal(function__, "w_0[sym1__]", w_0[(sym1__ - 1)], 1);
      }
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= n_data; ++sym1__) {
        current_statement__ = 7;
        current_statement__ = 7;
        check_greater_or_equal(function__, "w[sym1__]", w[(sym1__ - 1)], 0);}
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= n_data; ++sym1__) {
        current_statement__ = 7;
        current_statement__ = 7;
        check_less_or_equal(function__, "w[sym1__]", w[(sym1__ - 1)], 1);}
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= n_events; ++sym1__) {
        current_statement__ = 8;
        current_statement__ = 8;
        check_greater_or_equal(function__, "w_full[sym1__]",
                               w_full[(sym1__ - 1)], 0);}
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= n_events; ++sym1__) {
        current_statement__ = 8;
        current_statement__ = 8;
        check_less_or_equal(function__, "w_full[sym1__]",
                            w_full[(sym1__ - 1)], 1);}
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= n_params; ++sym1__) {
          vars__.emplace_back(lambdas[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= n_param_sets; ++sym1__) {
          vars__.emplace_back(sum_gammas[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= n_paths; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= n_params; ++sym2__) {
            vars__.emplace_back(
              rvalue(parlam,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())), "parlam"));
          }}
        for (int sym1__ = 1; sym1__ <= n_paths; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= n_nodes; ++sym2__) {
            vars__.emplace_back(
              rvalue(parlam2,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())), "parlam2"));
          }}
        for (int sym1__ = 1; sym1__ <= n_paths; ++sym1__) {
          vars__.emplace_back(w_0[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= n_data; ++sym1__) {
          vars__.emplace_back(w[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= n_events; ++sym1__) {
          vars__.emplace_back(w_full[(sym1__ - 1)]);}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      Eigen::Matrix<double, -1, 1> prob_of_types;
      prob_of_types = Eigen::Matrix<double, -1, 1>(n_types);
      stan::math::fill(prob_of_types, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 33;
      if (logical_eq(keep_transformed, 1)) {
        current_statement__ = 31;
        for (int i = 1; i <= n_types; ++i) {
          current_statement__ = 29;
          assign(prob_of_types, cons_list(index_uni(i), nil_index_list()),
            prod(
              subtract(
                add(
                  elt_multiply(
                    rvalue(P,
                      cons_list(index_omni(),
                        cons_list(index_uni(i), nil_index_list())), "P"),
                    lambdas), 1),
                rvalue(P,
                  cons_list(index_omni(),
                    cons_list(index_uni(i), nil_index_list())), "P"))),
            "assigning variable prob_of_types");}
      } 
      current_statement__ = 36;
      if (logical_eq(keep_transformed, 0)) {
        current_statement__ = 34;
        assign(prob_of_types, nil_index_list(), rep_vector(1, n_types),
          "assigning variable prob_of_types");
      } 
      for (int sym1__ = 1; sym1__ <= n_types; ++sym1__) {
        vars__.emplace_back(prob_of_types[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> gamma;
      gamma = Eigen::Matrix<double, -1, 1>(gamma_1dim__);
      stan::math::fill(gamma, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> gamma_flat__;
        current_statement__ = 1;
        assign(gamma_flat__, nil_index_list(), context__.vals_r("gamma"),
          "assigning variable gamma_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
          current_statement__ = 1;
          assign(gamma, cons_list(index_uni(sym1__), nil_index_list()),
            gamma_flat__[(pos__ - 1)], "assigning variable gamma");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> gamma_free__;
      gamma_free__ = Eigen::Matrix<double, -1, 1>(gamma_1dim__);
      stan::math::fill(gamma_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
        current_statement__ = 1;
        assign(gamma_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(gamma[(sym1__ - 1)], 0),
          "assigning variable gamma_free__");}
      for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
        vars__.emplace_back(gamma_free__[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("gamma");
    names__.emplace_back("lambdas");
    names__.emplace_back("sum_gammas");
    names__.emplace_back("parlam");
    names__.emplace_back("parlam2");
    names__.emplace_back("w_0");
    names__.emplace_back("w");
    names__.emplace_back("w_full");
    names__.emplace_back("prob_of_types");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(gamma_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_params)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(n_param_sets)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_params),
                                             static_cast<size_t>(n_paths)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_nodes),
                                             static_cast<size_t>(n_paths)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_paths)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_data)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_events)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_types)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "gamma" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n_params; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "lambdas" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_param_sets; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "sum_gammas" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_paths; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= n_params; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "parlam" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= n_paths; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= n_nodes; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "parlam2" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= n_paths; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "w_0" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_data; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "w" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_events; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "w_full" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= n_types; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "prob_of_types" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "gamma" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n_params; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "lambdas" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_param_sets; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "sum_gammas" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_paths; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= n_params; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "parlam" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= n_paths; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= n_nodes; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "parlam2" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= n_paths; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "w_0" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_data; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "w" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_events; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "w_full" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= n_types; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "prob_of_types" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"gamma\",\"type\":{\"name\":\"vector\",\"length\":" << gamma_1dim__ << "},\"block\":\"parameters\"},{\"name\":\"lambdas\",\"type\":{\"name\":\"vector\",\"length\":" << n_params << "},\"block\":\"transformed_parameters\"},{\"name\":\"sum_gammas\",\"type\":{\"name\":\"vector\",\"length\":" << n_param_sets << "},\"block\":\"transformed_parameters\"},{\"name\":\"parlam\",\"type\":{\"name\":\"matrix\",\"rows\":" << n_params << ",\"cols\":" << n_paths << "},\"block\":\"transformed_parameters\"},{\"name\":\"parlam2\",\"type\":{\"name\":\"matrix\",\"rows\":" << n_nodes << ",\"cols\":" << n_paths << "},\"block\":\"transformed_parameters\"},{\"name\":\"w_0\",\"type\":{\"name\":\"vector\",\"length\":" << n_paths << "},\"block\":\"transformed_parameters\"},{\"name\":\"w\",\"type\":{\"name\":\"vector\",\"length\":" << n_data << "},\"block\":\"transformed_parameters\"},{\"name\":\"w_full\",\"type\":{\"name\":\"vector\",\"length\":" << n_events << "},\"block\":\"transformed_parameters\"},{\"name\":\"prob_of_types\",\"type\":{\"name\":\"vector\",\"length\":" << n_types << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"gamma\",\"type\":{\"name\":\"vector\",\"length\":" << gamma_1dim__ << "},\"block\":\"parameters\"},{\"name\":\"lambdas\",\"type\":{\"name\":\"vector\",\"length\":" << n_params << "},\"block\":\"transformed_parameters\"},{\"name\":\"sum_gammas\",\"type\":{\"name\":\"vector\",\"length\":" << n_param_sets << "},\"block\":\"transformed_parameters\"},{\"name\":\"parlam\",\"type\":{\"name\":\"matrix\",\"rows\":" << n_params << ",\"cols\":" << n_paths << "},\"block\":\"transformed_parameters\"},{\"name\":\"parlam2\",\"type\":{\"name\":\"matrix\",\"rows\":" << n_nodes << ",\"cols\":" << n_paths << "},\"block\":\"transformed_parameters\"},{\"name\":\"w_0\",\"type\":{\"name\":\"vector\",\"length\":" << n_paths << "},\"block\":\"transformed_parameters\"},{\"name\":\"w\",\"type\":{\"name\":\"vector\",\"length\":" << n_data << "},\"block\":\"transformed_parameters\"},{\"name\":\"w_full\",\"type\":{\"name\":\"vector\",\"length\":" << n_events << "},\"block\":\"transformed_parameters\"},{\"name\":\"prob_of_types\",\"type\":{\"name\":\"vector\",\"length\":" << n_types << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_simplexes_namespace::model_simplexes;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_simplexes_namespace::profiles__;
}
#endif
#endif
