% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_helpers.R
\name{query_helpers}
\alias{query_helpers}
\alias{increasing}
\alias{non_decreasing}
\alias{decreasing}
\alias{non_increasing}
\alias{interacts}
\alias{complements}
\alias{substitutes}
\alias{te}
\title{Query helpers}
\usage{
increasing(X, Y)

non_decreasing(X, Y)

decreasing(X, Y)

non_increasing(X, Y)

interacts(X1, X2, Y)

complements(X1, X2, Y)

substitutes(X1, X2, Y)

te(X, Y)
}
\arguments{
\item{X}{A character. The quoted name of the input node}

\item{Y}{A character. The quoted name of the outcome node}

\item{X1}{A character. The quoted name of the input node 1.}

\item{X2}{A character. The quoted name of the input node 2.}
}
\value{
A character statement of class \code{statement}

A character statement of class \code{statement}

A character statement of class \code{statement}

A character statement of class \code{statement}

A character statement of class \code{statement}

A character statement of class \code{statement}

A character statement of class \code{statement}

A character statement of class \code{statement}
}
\description{
Various helpers to describe queries or parts of queries in natural language.

Generate a statement for Y monotonic (increasing) in X

Generate a statement for Y weakly monotonic (increasing) in X

Generate a statement for Y monotonic (decreasing) in X

Generate a statement for Y weakly monotonic (not increasing) in X

Generate a statement for X1, X1 interact in the production of Y

Generate a statement for X1, X1 complement each other in the production of Y

Generate a statement for X1, X1 substitute for each other
in the production of Y

Generate a statement for (Y(1) - Y(0)). This statement when applied to
a model returns an element in (1,0,-1) and not a set of cases.
This is useful for some purposes such as querying a model, but not for
uses that require a list of types, such as \code{set_restrictions}.
}
\examples{
\donttest{
increasing('A', 'B')
}
\donttest{
non_decreasing('A', 'B')
}
\donttest{
decreasing('A', 'B')
}
\donttest{
non_increasing('A', 'B')
}
\donttest{
interacts('A', 'B', 'W')
get_query_types(model = make_model('X-> Y <- W'),
         query = interacts('X', 'W', 'Y'), map = "causal_type")
}
\donttest{
complements('A', 'B', 'W')
}
\donttest{
get_query_types(model = make_model('A -> B <- C'),
         query = substitutes('A', 'C', 'B'),map = "causal_type")

query_model(model = make_model('A -> B <- C'),
         queries = substitutes('A', 'C', 'B'),
         using = 'parameters')
}
\donttest{
te('A', 'B')

model <- make_model('X->Y') |> set_restrictions(increasing('X', 'Y'))
query_model(model, list(ate = te('X', 'Y')),  using = 'parameters')

# set_restrictions  breaks with te because it requires a listing
# of causal types, not numeric output.
}
\dontrun{
model <- make_model('X->Y') |> set_restrictions(te('X', 'Y'))
}

}
\concept{statements}
