% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_Theta.R
\name{modify_Theta}
\alias{modify_Theta}
\title{Modify Theta Parameters in PML Models}
\usage{
modify_Theta(
  PMLParametersSets,
  Name,
  InitialEstimates,
  Frozen,
  PMLStructures = NULL
)
}
\arguments{
\item{PMLParametersSets}{A list of PML parameters sets (\code{PMLModels} class
instance).}

\item{Name}{Character specifying the name of the Theta to be modified.}

\item{InitialEstimates}{An \code{\link[=InitialEstimate]{InitialEstimate()}} class instance or a numerical
value for the initial estimate of the Theta or a numeric vector length
three with its elements representing the lower bound, initial estimate.}

\item{Frozen}{A logical value indicating whether the Theta will be estimated or not.}

\item{PMLStructures}{Character or character vector specifying names of PML
structures in which the \code{Theta} parameter will be modified. For the naming
convention of \code{PMLStructures}, see Details section of
\code{\link[=create_ModelPK]{create_ModelPK()}} for PK models and \code{\link[=create_ModelPD]{create_ModelPD()}} for PD models..}
}
\value{
An updated list of PML models (\code{PMLModels} class instance) matching
the specified options.
}
\description{
This function allows to modify Theta parameter in a list of PML models
(\code{PMLModels} class instance created by \code{\link[=create_ModelPK]{create_ModelPK()}} or \link{create_ModelPD}).
}
\details{
\itemize{
\item If the specified Theta does not exist in the PML models, a warning
will be issued, and no modifications will be made. Thetas associated with
structural parameters in the proportional part of MixRatio and
Additive+Proportional error models can also be modified.
\item The current functionality does not support modifying custom
thetas (fixefs) that are defined within the PML code of custom model spaces.
}
}
\examples{
PMLParametersSets <- create_ModelPK(CompartmentsNumber = c(1, 2))
# Modify a Theta parameter named "tvV" with new Initial Estimates and
# Frozen flag
PMLParametersSetsMod1 <-
  modify_Theta(PMLParametersSets,
               Name = "tvV",
               Frozen = TRUE,
               InitialEstimates = 0.3)

print(PMLParametersSetsMod1)

PMLParametersSetsMod2 <-
  add_StParm(PMLParametersSets = PMLParametersSetsMod1,
             StParmName = "Duration",
             State = "Searched",
             PMLStructures = "PK2IVC",
             DosepointArgName = "duration")

PMLParametersSetsMod3 <-
  modify_Theta(PMLParametersSets = PMLParametersSetsMod2,
               Name = "tvDuration",
               InitialEstimates = c(2, 4, Inf))

print(PMLParametersSetsMod3)

}
\seealso{
\code{\link[=InitialEstimate]{InitialEstimate()}}

Functions used for Theta specification: 
\code{\link{InitialEstimate}()},
\code{\link{Theta}()},
\code{\link{create_ModelPD}()},
\code{\link{create_ModelPK}()}
}
\concept{Thetas}
