% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfS_Triangular.R
\name{cfS_Triangular}
\alias{cfS_Triangular}
\title{Characteristic function of Triangular distribution}
\usage{
cfS_Triangular(t, a = 1)
}
\arguments{
\item{t}{numerical values (number, vector...)}

\item{a}{number, a > 0, default value a = 1}
}
\value{
characteristic function cf(t) of the Triangular distribution on the interval (-a, a) with mode 0
}
\description{
cfS_Triangular(t, a) evaluates the characteristic function cf(t) of
the Triangular distribution on the interval (-a, a) with mode 0
(Triangular distribution with mean = 0 and variance = 1/18(2a^2 + a)
cfS_Triangula(t, a) = (2 - 2cos(at)) / (a^2 * t^2)
}
\examples{
## EXAMPLE1 (CF of the symmetric Triangular distribution on (-2 , 2))
t <- seq(-10, 10, length.out = 501)
plotGraf(function(t)
  cfS_Triangular(t, 2), t, title = "CF of the symmetric Triangular distribution on (-2 , 2)")

## EXAMPLE2 (PDF/CDF of the symmetric Triangular distribution on (-3 , 3))
cf <- function(t)
  cfS_Triangular(t, 3)
x <- seq(-3, 3, length.out = 101)
prob <- c(0.9, 0.95, 0.99)
xRange <- 6
option <- list()
option$N <- 2 ^ 10
option$dx <- 2 / pi / xRange
result <- cf2DistGP(cf, x, option = option)
}
\seealso{
For more details see WIKIPEDIA:
\url{https://en.wikipedia.org/wiki/Triangular_distribution}

Other Continuous Probability distribution: \code{\link{cfS_Arcsine}},
  \code{\link{cfS_Beta}}, \code{\link{cfS_Gaussian}},
  \code{\link{cfS_Rectangular}},
  \code{\link{cfS_StudentT}},
  \code{\link{cfS_Trapezoidal}}, \code{\link{cfX_Beta}},
  \code{\link{cfX_ChiSquared}},
  \code{\link{cfX_Exponential}}, \code{\link{cfX_Gamma}},
  \code{\link{cfX_InverseGamma}},
  \code{\link{cfX_LogNormal}}, \code{\link{cfX_Normal}},
  \code{\link{cfX_PearsonV}},
  \code{\link{cfX_Rectangular}},
  \code{\link{cfX_Triangular}}

Other Symetric Probability distribution: \code{\link{cfS_Arcsine}},
  \code{\link{cfS_Gaussian}},
  \code{\link{cfS_Rectangular}},
  \code{\link{cfS_StudentT}}, \code{\link{cfS_Trapezoidal}}
}

