% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfX_Rectangular.R
\name{cfX_Rectangular}
\alias{cfX_Rectangular}
\title{Characteristic function of Rectangular distribution}
\usage{
cfX_Rectangular(t, a = -1, b = 1)
}
\arguments{
\item{t}{numerical values (number, vector...)}

\item{a}{number, default value a = -1}

\item{b}{number, default value b = 1}
}
\value{
characteristic function cf(t) of the Rectangular distribution on the interval (a, b)
}
\description{
cfX_Rectangular(t, a, b) evaluates the characteristic function cf(t) of
the Rectangular distribution on the interval (a, b)
(Rectangular distribution with mean = (a + b)/2 and variance = 1/12(b - a)^2)
cfX_Rectangular(t, a, b) = (exp(ibt) - exp(iat))/(i(b - a)t)
}
\examples{
## EXAMPLE1 (CF of the Rectangular distribution on (-2,1))
t <- seq(-50, 50, length.out = 501)
plotGraf(function(t)
  cfX_Rectangular(t, a = -2, b = 1), t, title = "CF of the Rectangular distribution on (-2,1)")

## EXAMPLE2 (PDF/CDF of the Rectangular distribution on (-2,1))
cf <- function(t)
  cfX_Rectangular(t, a = -2, b = 1)
x <- seq(-2, 1, length.out = 101)
prob <- c(0.9, 0.95, 0.99)
xRange <- 3
option <- list()
option$N <- 2 ^ 10
option$dx <- 2 / pi / xRange
result <- cf2DistGP(cf, x, prob, option)

## EXAMPLE3 (PDF/CDF of the Rectangular distribution on (-2,1))
cf <- function(t)
  cfX_Rectangular(t, a = -2, b = 1)
x <- seq(-2, 1, length.out = 101)
prob <- c(0.9, 0.95, 0.99)
result <- cf2DistGP(cf,
                    x,
                    prob,
                    xMin = -2,
                    xMax = 1,
                    N = 2)
}
\seealso{
For more details see WIKIPEDIA:
\url{https://en.wikipedia.org/wiki/Normal_distribution}

Other Continuous Probability distribution: \code{\link{cfS_Arcsine}},
  \code{\link{cfS_Beta}}, \code{\link{cfS_Gaussian}},
  \code{\link{cfS_Rectangular}},
  \code{\link{cfS_StudentT}},
  \code{\link{cfS_Trapezoidal}},
  \code{\link{cfS_Triangular}}, \code{\link{cfX_Beta}},
  \code{\link{cfX_ChiSquared}},
  \code{\link{cfX_Exponential}}, \code{\link{cfX_Gamma}},
  \code{\link{cfX_InverseGamma}},
  \code{\link{cfX_LogNormal}}, \code{\link{cfX_Normal}},
  \code{\link{cfX_PearsonV}}, \code{\link{cfX_Triangular}}
}

