% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Database.R
\name{createCharacterizationTables}
\alias{createCharacterizationTables}
\title{Create the results tables to store characterization results into a database}
\usage{
createCharacterizationTables(
  connectionDetails,
  resultSchema,
  targetDialect = "postgresql",
  deleteExistingTables = TRUE,
  createTables = TRUE,
  tablePrefix = "c_",
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema")
)
}
\arguments{
\item{connectionDetails}{The connectionDetails to a database created by using the
function \code{createConnectDetails} in the
\code{DatabaseConnector} package.}

\item{resultSchema}{The name of the database schema that the result tables will be created.}

\item{targetDialect}{The database management system being used}

\item{deleteExistingTables}{If true any existing tables matching the Characterization result tables names will be deleted}

\item{createTables}{If true the Characterization result tables will be created}

\item{tablePrefix}{A string appended to the Characterization result tables}

\item{tempEmulationSchema}{The temp schema used when the database management system is oracle}
}
\value{
Returns NULL but creates the required tables into the specified database schema.
}
\description{
This function executes a large set of SQL statements to create tables that can store results
}
\details{
This function can be used to create (or delete) Characterization result tables
}
\examples{
# create sqlite database
charResultDbCD <- createSqliteDatabase()

# create database results tables
createCharacterizationTables(
   connectionDetails = charResultDbCD,
   resultSchema = 'main'
 )

}
\seealso{
Other Database: 
\code{\link{createSqliteDatabase}()},
\code{\link{insertResultsToDatabase}()}
}
\concept{Database}
