% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aovPCAloadings.R
\name{aovPCAloadings}
\alias{aovPCAloadings}
\title{Plot aovPCAscores Loadings of a Spectra Object}
\usage{
aovPCAloadings(spectra, PCA, submat = 1, loads = 1, ref = 1, ...)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link[=Spectra]{Spectra()}}.}

\item{PCA}{List of pca results created by \code{\link{aov_pcaSpectra}}.}

\item{submat}{Integer.  Selects list element \code{submat} from \code{PCA}
which is a list of PCA results, each corresponding to the computation
in \code{\link{aov_pcaSpectra}}.}

\item{loads}{An integer vector giving the loadings to plot.}

\item{ref}{An integer specifying the reference spectrum to plot, which
appears at the bottom of the plot.}

\item{\dots}{Parameters to be passed to the plotting routines. \emph{Applies to base graphics only}.}
}
\value{
The returned value depends on the graphics option selected (see \code{\link[ChemoSpecUtils:GraphicsOptions]{ChemoSpecUtils::GraphicsOptions()}}).
\itemize{
\item \code{base}: None.  Side effect is a plot.
\item \code{ggplot2}: The plot is displayed, and a \code{ggplot2} object is returned if the value is assigned.  The plot can be modified in the usual \code{ggplot2} manner.
}
}
\description{
Uses the results from \code{\link{aovPCAscores}} to plot the corresponding
loadings.
}
\references{
Pinto, Bosc, Nocairi, Barros, and Rutledge. "Using ANOVA-PCA for
Discriminant Analysis: ..." Analytica Chimica Acta 629.1-2 (2008): 47-55.

Harrington, Vieira, Espinoza, Nien, Romero, and Yergey. "Analysis of
Variance--Principal Component Analysis: ..." Analytica Chimica Acta 544.1-2
(2005): 118-27.
}
\seealso{
An example using this function can be seen in
\code{\link{aov_pcaSpectra}}.  See also \code{\link{plotLoadings}}.
Additional documentation at \url{https://bryanhanson.github.io/ChemoSpec/}
}
\author{
Bryan A. Hanson (DePauw University), Matthew J. Keinsley.
}
\keyword{htest}
\keyword{multivariate}
