% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conColScheme.R
\name{conColScheme}
\alias{conColScheme}
\title{Change the Color Scheme of a Spectra or Spectra2D Object}
\usage{
conColScheme(spectra, new.cols = NULL, silent = FALSE)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link[ChemoSpec]{Spectra}} or
\code{\link[ChemoSpec2D]{Spectra2D}}.}

\item{new.cols}{A character vector giving the new color values, of
\code{length(unique(spectra$colors))}.
If not provided, the function will print the old values for reference.}

\item{silent}{Logical.  If \code{TRUE}, suppresses all reporting.}
}
\value{
spectra An updated object of S3 class \code{\link[ChemoSpec]{Spectra}} or
\code{\link[ChemoSpec2D]{Spectra2D}}\code{\link[ChemoSpec2D]{Spectra2D}}.
}
\description{
This function permits you to change the color scheme of an existing
\code{\link[ChemoSpec]{Spectra}} or \code{\link[ChemoSpec2D]{Spectra2D}} object.
}
\examples{
if (checkForPackageWithVersion("ChemoSpec", 6.0)) {
  library("ChemoSpec")
  data(metMUD1)

  sumSpectra(metMUD1)
  newSpec <- conColScheme(metMUD1) # reports old colors
  newSpec <- conColScheme(metMUD1, new = c("pink", "violet"))
}

if (checkForPackageWithVersion("ChemoSpec2D", 0.5)) {
  library("ChemoSpec2D")
  data(MUD1)

  sumSpectra(MUD1)
  newSpec <- conColScheme(MUD1) # reports old colors
  newSpec <- conColScheme(MUD1, new = c("pink", "violet"))
}
}
\seealso{
For a discussion of general issues of color, see
\code{colorSymbol}.
}
\author{
Bryan A. Hanson (DePauw University)
}
\keyword{color}
\keyword{utilities}
