% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateGroups.R
\name{updateGroups}
\alias{updateGroups}
\title{Update Group Names in a Spectra or Spectra2D Object}
\usage{
updateGroups(spectra, new.grps = NULL, silent = FALSE)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link[ChemoSpec:Spectra]{ChemoSpec::Spectra()}} or \code{\link[ChemoSpec2D:Spectra2D]{ChemoSpec2D::Spectra2D()}}.}

\item{new.grps}{A vector of character values giving the new group names.
The new values must correspond to the order of the old values.  This vector should
give the unique values only (so, it should have \code{length(unique(spectra$groups))}).
If not provided, the function will print the old values for reference.}

\item{silent}{Logical.  If \code{TRUE}, suppresses all reporting.}
}
\value{
spectra An object of S3 class \code{\link[ChemoSpec:Spectra]{ChemoSpec::Spectra()}} or \code{\link[ChemoSpec2D:Spectra2D]{ChemoSpec2D::Spectra2D()}}.
}
\description{
A convenience function that can be used to update (change)
group names.  The default group names come from the \code{gr.crit}
argument in the import functions \code{\link[ChemoSpec]{files2SpectraObject}},
\code{\link[ChemoSpec]{matrix2SpectraObject}} or
\code{\link[ChemoSpec2D]{files2Spectra2DObject}}. In some cases \code{gr.crit}
may have complex regex patterns, and this function makes updating them to more
appropriate/more readible strings easier.
}
\examples{
if (checkForPackageWithVersion("ChemoSpec", 6.0)) {
  library("ChemoSpec")
  data(metMUD1)
  metMUD1a <- updateGroups(metMUD1) # reports old groups
  metMUD1a <- updateGroups(metMUD1, new.grps = c("C", "T"))
}

if (checkForPackageWithVersion("ChemoSpec2D", 0.5)) {
  library("ChemoSpec2D")
  data(MUD1)
  MUD1a <- updateGroups(MUD1, new.grps = c("control", "treatment"))
}
}
\author{
Bryan A. Hanson (DePauw University).
}
