% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_chart.R
\name{plot_chart}
\alias{plot_chart}
\title{Plot summary chart}
\usage{
plot_chart(lattes.list, chart.type = c("ggplot2", "plotly", "rCharts"),
  width = 960, height = 480, language = c("EN", "PT"),
  which.fields = c("journal.accepted", "journal.published",
  "conference.international", "conference.national", "book.chapters", "books",
  "phd.theses", "msc.theses"))
}
\arguments{
\item{lattes.list}{a Lattes list object created using \code{\link[=lattes_to_list]{lattes_to_list()}}}

\item{chart.type}{package to use for generating the summary chart. "plotly" and
"rCharts" output interactive charts, "ggplot2" outputs a static one. Option
"rCharts" is currently disabled, until the rCharts package
(\url{https://github.com/ramnathv/rCharts})
becomes available on CRAN.}

\item{width}{plot width (for "plotly" and "rCharts")}

\item{height}{plot height (for "plotly")}

\item{language}{Language to use in section headers}

\item{which.fields}{Character vector indicating which fields to include in
the productions page.}
}
\value{
plot object for inclusion in a productions page
(see \code{\link[=make_productions_page]{make_productions_page()}}.
}
\description{
Plot summary chart from a Lattes list object
}
\details{
This function plots production information from a Lattes list object
generated by \code{\link[=lattes_to_list]{lattes_to_list()}}:
\itemize{
\item Accepted journal papers
\item Published journal papers
\item Published conference papers
\item Published book chapters
\item Published books
\item Ph.D. student defenses
\item M.Sc. student defenses
}
}
