% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CD.R
\name{CD}
\alias{CD}
\title{Concede-and-divide rule}
\usage{
CD(E, d, name = FALSE)
}
\arguments{
\item{E}{The endowment.}

\item{d}{The vector of two claims.}

\item{name}{A logical value.}
}
\value{
The awards vector selected by the CD rule. If name = TRUE, the name of the function (CD) as a character string.
}
\description{
This function returns the awards vector assigned by the concede-and-divide (CD) rule to a two-claimant problem.
}
\details{
Let \eqn{E\ge 0} be the endowment to be divided and \eqn{d=(d_1,d_2)\in \mathcal{R}^2}{%
d=(d1,d2)} the vector of claims
with \eqn{d\ge 0} and such that the sum of the two claims exceeds the endowment \eqn{d_1+d_2 \ge E}{d1+d2\ge E}.

The concede-and-divide rule first assigns to each of the two claimants the difference between the endowment and the other agent’s claim (or 0 if this
difference is negative), and divides the remainder equally.
\deqn{CD_1(E,d)=\max\{E-d_2,0\}+\frac{E-\max\{E-d_1,0\}-\max\{E-d_2,0\}}{2}}{CD1(E,d) = max\{E-d2,0\} + 1/2(E-max\{E-d1,0\}-max\{E-d2,0\})}
 \deqn{CD_2(E,d)=\max\{E-d_1,0\}+\frac{E-\max\{E-d_1,0\}-\max\{E-d_2,0\}}{2}}{CD2(E,d) = max\{E-d1,0\} + 1/2(E-max\{E-d1,0\}-max\{E-d2,0\})}
Several rules are extensions of the concede-and-divide rule to general populations: AA, APRO, MO, RA, and Talmud.
}
\examples{
E=10
d=c(7,8)
CD(E,d)
# Talmud, RA, MO, APRO, and AA coincide with CD for two-claimant problems
Talmud(E,d)
RA(E,d)
MO(E,d)
APRO(E,d)
AA(E,d)
}
\references{
Aumann, R. and Maschler, M., (1985). Game theoretic analysis of a bankruptcy problem from the Talmud. J. Econ. Theory 36, 195–213.

Mirás Calvo, M. A., Núñez Lugilde, I., Quinteiro Sandomingo, C., and Sánchez Rodríguez, E. (2021).  Analyzing rules that extend the concede-and-divide principle. Preprint.

Thomson, W. (2019). How to divide when there isn't enough. From Aristotle, the Talmud, and Maimonides to the axiomatics of resource allocation. Cambridge University Press.
}
\seealso{
\link{allrules}, \link{pathawards}, \link{AA}, \link{APRO}, \link{MO}, \link{RA}, \link{Talmud}
}
