% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{mai}
\alias{mai}
\title{De Martonne aridity index}
\usage{
mai(pr, taverage, data_names = NULL, na.rm = FALSE, ...)
}
\arguments{
\item{pr}{precipitation}

\item{taverage}{medium temperature}

\item{data_names}{names of each period of time}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}

\item{...}{...}
}
\value{
Martonne Aridity Index
}
\description{
De Martonne aridity index is the ratio between the annual amount of precipitation and anual mean of temperature plus 10 Celsius.
}
\section{Formula}{
 \deqn{MAI = \frac{P} {TG+10}} P = annual precipitation (mm); TG = mean annual air temperature (Celsius)
}

\examples{
data(data_all)
mai(pr = data_all$rr, taverage = data_all$tg)
}
\references{
De Martonne E., 1926. Une nouvelle fonction climatologique: L’indice d’aridité. La Meteorologie, 449-458.
}
