% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.lsmeans.R
\name{report.lsmeans}
\alias{report.lsmeans}
\title{'LS Means' statistics reporting}
\usage{
report.lsmeans(lsm, at.row = NULL, infer = c(T, T), round = 2, x1,
  x2, x3, x1.name, x2.name, x3.name, data, contrast, contrast.name, type,
  transpose = FALSE, y.label = NULL)
}
\arguments{
\item{lsm}{emmGrid object (result of a \code{emmeans} call)}

\item{at.row}{Character. Passed to spacetable function. Used to space the results per levels of the mentioned variable}

\item{infer}{A vector of one or two logical values. Passed to \code{summary.emmGrid} function.}

\item{round}{Numeric. Specify the number of digits to round the statistics}

\item{x1}{deprecated}

\item{x2}{deprecated}

\item{x3}{deprecated}

\item{x1.name}{deprecated}

\item{x2.name}{deprecated}

\item{x3.name}{deprecated}

\item{data}{deprecated}

\item{contrast}{deprecated}

\item{contrast.name}{deprecated}

\item{type}{deprecated}

\item{transpose}{Logical. If TRUE Statistics will be reported in columns}

\item{y.label}{Character Indicates the label for y parameter to be displayed in the title of the table}
}
\value{
A desc object that can be used by the \code{report.doc} function.
}
\description{
Creates a desc object for "LS Means" statistics reporting.
}
\details{
You can produce formatted Least Square Means table for up to 3 factors.
It doesn't work for quantitative covariates.

 See examples below.
}
\examples{

library(emmeans)
library(lme4)

data(datafake)

#Simple lm model

mod=lm(Petal.Width~Species,data=iris)
raw.lsm=emmeans(mod,~Species)
report.lsmeans(raw.lsm)

# You can display the Statistics in columns

report.lsmeans(raw.lsm,transpose=TRUE)

# In case of just one intercept 

mod=glm(Species~1,data=iris,family=binomial)
raw.lsm=emmeans(mod,~1)
report.lsmeans(raw.lsm)

# Display statistics in columns

report.lsmeans(raw.lsm,transpose=TRUE)


#Mixed model example using lme4

mod=lmer(y_numeric~GROUP+TIMEPOINT+GROUP*TIMEPOINT+(1|SUBJID),data=datafake) 
raw.lsm=emmeans(mod,~GROUP|TIMEPOINT)
report.lsmeans(lsm=raw.lsm,at="TIMEPOINT")

# Display statistics in columns

report.lsmeans(lsm=raw.lsm,at="TIMEPOINT",transpose=TRUE)


# GLM model with specific contrast

warp.lm <- lm(breaks ~ wool+tension+wool:tension, data = warpbreaks)
warp.emm <- emmeans(warp.lm, ~ tension | wool)
contr=contrast(warp.emm, "trt.vs.ctrl", ref = "M")
report.lsmeans(lsm=contr,at="wool")


# Display statistics in columns

report.lsmeans(lsm=contr,at="wool",transpose=TRUE)


# Cox model

library(survival)

data(time_to_cure)

fit <- coxph(Surv(time, status) ~ Group, data = time_to_cure) 
em=emmeans(fit,~Group,type="response")
pairs=pairs(em,adjust="none",exclude="Untreated")
pairs

report.lsmeans(pairs)

# Display statistics in columns

report.lsmeans(pairs,transpose=TRUE)

}
\seealso{
\code{\link{report.quali}} \code{\link{emmeans}} \code{\link{report.doc}} \code{\link{desc}}
}
