% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thresh_3class.R
\name{optThres3}
\alias{optThres3}
\title{Estimation of the covariate-specific optimal pair of thresholds for clustered data.}
\usage{
optThres3(
  method = c("GYI", "CtP", "MV"),
  out_lme2,
  newdata,
  apVar = TRUE,
  data,
  control = list()
)
}
\arguments{
\item{method}{the method to be used. See 'Details'.}

\item{out_lme2}{an object of class "lme2", i.e., a result of \code{\link{lme2}} call.}

\item{newdata}{a data frame (containing specific value(s) of covariate(s)) in which to look for variables with which to estimate covariate-specific optimal pair of thresholds. In absence of covariate, no values have to be specified.}

\item{apVar}{logical value. If set to \code{TRUE}, the variance-covariance matrix of (estimated) covariate-specific optimal thresholds is estimated.}

\item{data}{a data frame containing the variables to be used when performing a bootstrap procedure to estimate the variance-covariance matrix, in case of Box-Cox transformation.}

\item{control}{a list of control parameters. See 'Details'.}
}
\value{
\code{optThres3} returns an object of "optThres3" class, which is a list containing at least the following components:

\item{call}{the matched call.}
\item{method}{the methods used to obtain the estimated optimal pair of threholds.}
\item{thres3}{a vector or matrix containing the estimated optimal thresholds.}
\item{thres3_se}{a vector or matrix containing the estimated standard errors.}
\item{vcov.thres3}{a matrix or list of matrices containing the estimated variance-covariance matrices.}
\item{tcfs}{a vector or matrix containing the estimated TCFs at the optimal thresholds.}
\item{mess_order}{a diagnostic message from checking the monontone ordering.}
\item{newdata}{value(s) of covariate(s).}
\item{n_p}{total number of regressors in the model.}

Generic functions such as \code{print} and \code{plot} are also used to show the results.
}
\description{
\code{optThres3} estimates covariate-specific optimal pair of thresholds of a continuous diagnostic test in a clustered design, with three classes of diseases.
}
\details{
This function implements estimation methods discussed in To et al. (2022) for covariate-specific optimal pair of thresholds in a clustered design with three ordinal groups. The estimators are based on the results from \code{\link{lme2}} function, which fits the linear mixed-effect model by using REML approach.

Before performing estimation, a check for the monotone ordering assumption is performed. This means that, for the fixed values of covariates, three predicted mean values for test results in three diagnostic groups are compared. If the assumption is not meet, the covariate-specific optimal pair of thresholds at the values of covariates are not estimated.

The estimation procedure uses three criteria. Method \code{"GYI"} is Generalized Youden Index, which maximizes the sum of three covariate-specific True Class Fractions - TCFs. Method \code{"CtP"} is based on Closest to Pefection approach. By using this method, the optimal pair of thresholds is obtained by minimizing the distance, in the unit cube, between a generic point on the covariate-specific ROC surface and the top corner (1, 1, 1). Method \code{"MV"} is based on Maximum Volume approach, which searches for thresholds that maximize the volume of a box under the covariate-specific ROC surface. The user can select more than one method. This function allows to estimate covariate-specific optimal pair of thresholds at multiple points for covariates.

The asymptotic variance-covariance matrix of the (estimated) covariate-specific optimal thresholds is estimated by using the Delta method under the normal assumption. If the Box-Cox transformation is applied to the linear mixed-effect model, a nonparametric bootstrap procedure for clustered data will be used to obtain the estimated asymptotic covariance matrix (see To et al. 2022, for more details).

The \code{control} argument is a list that can supply any of the following components:
\describe{
  \item{\code{method.optim}}{Optimization method to be used. There are three options: \code{"L-BFGS-B"}, \code{"BFGS"} and \code{"Nelder-Mead"}. Default is \code{"L-BFGS-B"}.}
  \item{\code{start}}{Starting values in the optimization procedure. If it is \code{NULL}, a starting point will be automatically obtained.}
  \item{\code{maxit}}{The maximum number of iterations. Default is 200.}
  \item{\code{lower, upper}}{Possible bounds on the threshold range, for the optimization based on "L-BFGS-B" method. Defaults are \code{-Inf} and \code{Inf}.}
  \item{\code{nR}}{Number of bootstrap replicates for estimating the covariance matrix (when Box-Cox transformation is applied). Default is 250.}
  \item{\code{parallel}}{A logical value. If set to \code{TRUE}, a parallel computing is employed in the bootstrap resampling process.}
  \item{\code{ncpus}}{Number of processes to be used in parallel computing. Default is 2.}
}
}
\examples{
data(data_3class)
## One covariate
out1 <- lme2(fixed.formula = Y ~ X1, name.class = "D", name.clust = "id_Clus",
             data = data_3class)

### Estimate covariate-specific optimal thresholds at multiple values of one covariate,
### with 3 methods
out_thres_1 <- optThres3(method = c("GYI", "MV", "CtP"), out_lme2 = out1,
                         newdata = data.frame(X1 = 1), apVar = TRUE)
print(out_thres_1)
plot(out_thres_1)

## Two covariates
out2 <- lme2(fixed.formula = Y ~ X1 + X2, name.class = "D", name.clust = "id_Clus",
             data = data_3class)

### Estimate covariate-specific optimal thresholds at one point, with 3 methods
out_thres_2 <- optThres3(method = c("GYI", "MV", "CtP"), out_lme2 = out2,
                         newdata = data.frame(X1 = 1, X2 = 0), apVar = TRUE)
print(out_thres_2)
plot(out_thres_2)

### Estimate covariate-specific optimal thresholds at three points, with 3 methods
out_thres_3 <- optThres3(method = c("GYI", "MV", "CtP"), out_lme2 = out2,
                         newdata = data.frame(X1 = c(-0.5, 0.5, 0.5), X2 = c(0, 0, 1)),
                         apVar = TRUE)
print(out_thres_3)
plot(out_thres_3, colors = c("forestgreen", "blue"))

}
\references{
To, D-K., Adimari, G., Chiogna, M. and Risso, D. (2022)
``Receiver operating characteristic estimation and threshold selection criteria in three-class classification problems for clustered data''. \emph{Statistical Methods in Medical Research}, DOI: 10.1177/09622802221089029.
}
