% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.clustatis.R
\name{plot.clustatis}
\alias{plot.clustatis}
\title{Displays the CLUSTATIS graphs}
\usage{
\method{plot}{clustatis}(x, ngroups=NULL, Graph_groups=TRUE, Graph_dend=TRUE,
Graph_bar=FALSE, Graph_weights=FALSE, axes=c(1,2), col=NULL, cex=1, font=1, ...)
}
\arguments{
\item{x}{object of class 'clustatis'.}

\item{ngroups}{number of groups to consider.  Ignored for clustatis_kmeans results. Default: recommended  number of clusters}

\item{Graph_groups}{logical. Should each cluster compromise graphical representation be plotted? Default: TRUE}

\item{Graph_dend}{logical. Should the dendrogram be plotted? Default: TRUE}

\item{Graph_bar}{logical. Should the barplot of the difference of the criterion and the barplot of the overall homogeneity at each merging step of the hierarchical algorithm be plotted? Also available after consolidation if Noise_cluster=FALSE. Default: FALSE}

\item{Graph_weights}{logical. Should the barplot of the weights in each cluster be plotted? Default: FALSE}

\item{axes}{numerical vector (length 2). Axes to be plotted. Default: c(1,2)}

\item{col}{vector. Color for each object. Default: rainbow(nrow(Data))}

\item{cex}{numerical. Numeric character expansion factor; multiplied by par("cex") yields the final character size. NULL and NA are equivalent to 1.0.}

\item{font}{numerical. Integer specifying font to use for text. 1=plain, 2=bold, 3=italic, 4=bold italic, 5=symbol. Default: 1}

\item{...}{further arguments passed to or from other methods}
}
\value{
the CLUSTATIS graphs
}
\description{
This function plots dendrogram, variation of the merging criterion, weights and STATIS map of each cluster
}
\examples{
\donttest{
 data(smoo)
 NameBlocks=paste0("S",1:24)
 cl=clustatis(Data=smoo,Blocks=rep(2,24),NameBlocks = NameBlocks)
 plot(cl, ngroups=3, Graph_dend=FALSE)
 plot(cl, ngroups=3,  Graph_dend=FALSE, axes=c(1,3))
 graphics.off()
 }

}
\seealso{
\code{\link{clustatis}} , \code{\link{clustatis_kmeans}}
}
\keyword{quantitative}
