% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statis_FreeSort.R
\name{statis_FreeSort}
\alias{statis_FreeSort}
\title{Performs the STATIS method on Free Sorting data}
\usage{
statis_FreeSort(Data, NameSub=NULL, Graph_obj=TRUE, Graph_weights=TRUE)
}
\arguments{
\item{Data}{data frame or matrix. Corresponds to all variables that contain subjects results. Each column corresponds to a subject and gives the groups to which the products (rows) are assigned}

\item{NameSub}{string vector. Name of each subject. Length must be equal to the number of clumn of the Data. If NULL, the names are S1,...Sm. Default: NULL}

\item{Graph_obj}{logical. Show the graphical representation od the objects? Default: TRUE}

\item{Graph_weights}{logical. Should the barplot of the weights be plotted? Default: TRUE}
}
\value{
a list with:

a list with:
        \itemize{
         \item RV: the RV matrix: a matrix with the RV coefficient between subjects
         \item compromise: a matrix which is the compromise of the subjects (akin to a weighted average)
         \item weights: the weights associated with the subjects to build the compromise
         \item lambda: the first eigenvalue of the RV matrix
         \item overall error : the error for the STATIS criterion
         \item error_by_conf: the error by configuration (STATIS criterion)
         \item rv_with_compromise: the RV coefficient of each subject with the compromise
         \item homogeneity: homogeneity of the subjects (in percentage)
         \item coord: the coordinates of each object
         \item eigenvalues: the eigenvalues of the svd decomposition
         \item inertia: the percentage of total variance explained by each axis
         \item error_by_obj: the error by object (STATIS criterion)
         \item scalefactors: the scaling factors of each subject
         \item proj_config: the projection of each object of each subject on the axes: presentation by subject
         \item proj_objects: the projection of each object of each subject on the axes: presentation by object
         }
}
\description{
STATIS method on Free Sorting data. A lot of supplementary informations are also computed
}
\examples{

data(choc)
res.sta=statis_FreeSort(choc)

}
\references{
\itemize{
\item Lavit, C., Escoufier, Y., Sabatier, R., Traissac, P. (1994). The act (statis method). Computational 462 Statistics & Data Analysis, 18 (1), 97-119.\\
\item Llobell, F., Cariou, V., Vigneau, E., Labenne, A., & Qannari, E. M. (2018). Analysis and clustering of multiblock datasets by means of the STATIS and CLUSTATIS methods.Application to sensometrics. Food Quality and Preference, in Press.
}
}
\seealso{
\code{\link{preprocess_FreeSort}}, \code{\link{clustatis_FreeSort}}
}
\keyword{FreeSorting}
