% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consistency_cata_panel.R
\name{consistency_cata_panel}
\alias{consistency_cata_panel}
\title{Test the consistency of the panel in a CATA experiment}
\usage{
consistency_cata_panel(Data,nblo, nperm=100, alpha=0.05)
}
\arguments{
\item{Data}{data frame or matrix. Correspond to all the blocks of variables merged horizontally}

\item{nblo}{numerical. Number of blocks (subjects).}

\item{nperm}{numerical. How many permutations are required? Default: 100}

\item{alpha}{numerical between 0 and 1. What is the threshold? Default: 0.05}
}
\value{
a list with:
        \itemize{
         \item answer: the answer of the test
         \item pval: pvalue of the test
         \item dis: distance between the homogeneity and the median of the permutations
         }
}
\description{
Permutation test on the agreement between subjects in a CATA experiment
}
\examples{
\donttest{
 data(straw)
#with all subjects
consistency_cata_panel(Data=straw, nblo=114)
}

}
\references{
Llobell, F., Giacalone, D., Labenne, A.,  Qannari, E.M. (2019).	Assessment of the agreement and cluster analysis of the respondents in a CATA experiment.	Food Quality and Preference, 77, 184-190.
Bonnet, L., Ferney, T., Riedel, T., Qannari, E.M., Llobell, F. (September 14, 2022) .Using CATA for sensory profiling: assessment of the panel performance. Eurosense, Turku, Finland.
}
\seealso{
\code{\link{consistency_cata}}, \code{\link{change_cata_format}}, \code{\link{change_cata_format2}}
}
\keyword{CATA}
