% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_CLV.R
\name{lm_CLV}
\alias{lm_CLV}
\title{linear model based on CLV : prediction of a response variable, y, based on clusters of explanatory variables, X.}
\usage{
lm_CLV(X, y, method = "directional", sX = sX, nbiter = 100,
  strategy = "none", rho = 0.3, shrinkp = 1, validation = FALSE,
  id.test = NULL)
}
\arguments{
\item{X}{: The matrix of the explanatory variables, to be clustered}

\item{y}{: The response variable (numeric)}

\item{method}{: The criterion to be use in the cluster analysis.  \cr
1 or "directional" : the squared covariance is used as a measure of proximity (directional groups). \cr    
2 or "local"       : the covariance is used as a measure of proximity (local groups)}

\item{sX}{: TRUE/FALSE, i.e. standardization or not of the columns X (TRUE by default)\cr
(predefined -> cX = TRUE : column-centering of X)}

\item{nbiter}{: maximum number of steps (by default nbiter=100)}

\item{strategy}{: "none" (by default), or "kplusone" (an additional cluster for the noise variables),
or "sparselv" (zero loadings for the noise variables)}

\item{rho}{: a threshold of correlation between 0 and 1 (used for kplusone or sparselv strategies, 0.3 by default)}

\item{shrinkp}{: shrinkage  paramater used in the boosting (1 by default)}

\item{validation}{TRUE/FALSE i.e. using a test set or not. By default no validation}

\item{id.test}{: if validation==TRUE, the number of the observations used as test set}
}
\value{
\item{Group}{a list of the groups of variables X iteratively extracted.}

\item{Comp}{ a list of the latent variables associated with the groups of X variables extracted.}

\item{Load}{ a list for the loadings of the X variables according to the associated latent variable.}

\item{Beta}{ a list for the coefficients associated to the scaled predictors (X must to be scaled accordind to sX) regarding y .}
}
\description{
boosted-liked procedure for identifying groups of explanatory variables (and the associated latent variable) specifically correlated with the response variable, y.
Directional groups are considered. 
Discarding spurious variables is allowed using the strategy and rho parameters.
}
\seealso{
CLV, CLV_kmeans
}
