% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_weight.R
\name{get_weight}
\alias{get_weight}
\title{Weights of the external variables, or additional mode, on the latent component in each cluster.}
\usage{
get_weight(resclv, K = NULL, graph = FALSE, cex.lab = 1)
}
\arguments{
\item{resclv}{: result of CLV(), CLV_kmeans() or LCLV(), CLV3W() or CLV3W_kmeans()}

\item{K}{: the number of clusters chosen (already defined if CLV_kmeans or CLV3W_kmeans is used)}

\item{graph}{: boolean, if TRUE, the barplot associated with the scores is displayed (default : graph=FALSE)}

\item{cex.lab}{: magnification to be used for labels (1 by default)}
}
\value{
\item{weight}{Weights in each cluster (associated with mode 3 for CLV3W object) \cr
      For each cluster, the vector of weights is set to length 1 \cr
      output provided as matrix with K columns (K: number of clusters) \cr
      In the special case of LCLV, two matrices of weights are defined : \cr
      weight_v : weights of the external Xr variables, \cr
      weight_u : weights of the external Xu variables.
     }
}
\description{
To get the weigths associated with each cluster.
 For CLV(_kmeans) or LCLV, applies only when external variables (Xr, Xu or both) are involved.
 For CLV3W(_kmeans), the weights are associated with the third mode of the 3-way array.
}
