% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusbootglm_s3_methods.R
\name{summary.clusbootglm}
\alias{summary.clusbootglm}
\title{Summarize output of cluster bootstrap GLM}
\usage{
\method{summary}{clusbootglm}(object, interval.type = "BCa", ...)
}
\arguments{
\item{object}{object of class \code{clusbootglm}.}

\item{interval.type}{which confidence interval should be used. Options are \code{parametric}, \code{percentile}, and \code{BCa} intervals.}

\item{...}{other arguments.}
}
\description{
Returns the summary of an object of class \code{clusbootglm}.
}
\examples{
\dontrun{
data(opposites)
cbglm.1 <- clusbootglm(SCORE~Time*COG,data=opposites,clusterid=Subject)
summary(cbglm.1, interval.type="percentile")}
}
\author{
Mathijs Deen
}
