% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_functions.R
\name{center_scale}
\alias{center_scale}
\title{Function to scale and/or center the data}
\usage{
center_scale(data, mean_center = TRUE, sd_scale = TRUE)
}
\arguments{
\item{data}{matrix or data frame}

\item{mean_center}{either TRUE or FALSE. If mean_center is TRUE then the mean of each column will be subtracted}

\item{sd_scale}{either TRUE or FALSE. See the details section for more information}
}
\value{
a matrix
}
\description{
Function to scale and/or center the data
}
\details{
If sd_scale is TRUE and mean_center is TRUE then each column will be divided by the standard deviation. If sd_scale is TRUE and mean_center is FALSE then each
column will be divided by sqrt( sum(x^2) / (n-1) ).
In case of missing values the function raises an error.
In case that the standard deviation equals zero then the standard deviation will be replaced with 1.0, so that NaN's can be avoided by division
}
\examples{

data(dietary_survey_IBS)

dat = dietary_survey_IBS[, -ncol(dietary_survey_IBS)]

dat = center_scale(dat, mean_center = TRUE, sd_scale = TRUE)

}

