% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_functions.R
\name{predict_KMeans}
\alias{predict_KMeans}
\title{Prediction function for the k-means}
\usage{
predict_KMeans(data, CENTROIDS)
}
\arguments{
\item{data}{matrix or data frame}

\item{CENTROIDS}{a matrix of initial cluster centroids. The rows of the CENTROIDS matrix should be equal to the number of clusters and the columns should be equal to the columns of the data.}
}
\value{
a vector (clusters)
}
\description{
Prediction function for the k-means
}
\details{
This function takes the data and the output centroids and returns the clusters.
}
\examples{

data(dietary_survey_IBS)

dat = dietary_survey_IBS[, -ncol(dietary_survey_IBS)]

dat = center_scale(dat)

km = KMeans_rcpp(dat, clusters = 2, num_init = 5, max_iters = 100, initializer = 'kmeans++')

pr = predict_KMeans(dat, km$centroids)
}
\author{
Lampros Mouselimis
}
