% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{evaluate_validation_external_by_metrics}
\alias{evaluate_validation_external_by_metrics}
\title{Evaluate external validations by algorithm.}
\usage{
evaluate_validation_external_by_metrics(df)
}
\arguments{
\item{df}{data matrix or data frame with the result of running the clustering
algorithm.}
}
\value{
A data.frame with all the algorithms that obtain the best results
regardless of the dissimilarity measure used.
}
\description{
Method that calculates which algorithm behaves best for the
datasets provided.
}
\details{
It groups the results of the execution by algorithms.
}
\examples{

result = clustering(
               df = cluster::agriculture,
               min = 4,
               max = 4,
               algorithm='kmeans_arma',
               metrics=c("Precision")
         )

evaluate_validation_external_by_metrics(result)


}
