% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateTS.R
\name{regenerateTS}
\alias{regenerateTS}
\title{Bulk Timeseries generation}
\usage{
regenerateTS(ts, TSn = 1)
}
\arguments{
\item{ts}{generated timeseries using ARp}

\item{TSn}{number of timeseries to be (re)generated}
}
\description{
Resamples given Timeseries
}
\details{
You have used the generateTS function and you wish to generate more time series. Instead of re-running generateTS you can use regenerateTS, which generates timeseries using the parameters previously calculated by the generateTS function,  and thus it is faster.
}
\examples{

library(CoSMoS)

## define marginal distribution and arguments with target
## autocorrelation structure
x <- generateTS(margdist = 'burrXII',
                margarg = list(scale = 1,
                               shape1 = .75,
                               shape2 = .25),
                acsvalue = acs(id = 'weibull',
                               t = 0:30,
                               scale = 10,
                               shape = .75),
                n = 1000, p = 30, p0 = .5, TSn = 3)

## generate new values with same parameters
r <- regenerateTS(x)

plot(r)

}
