% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableAchillesCodeUse.R
\name{tableOrphanCodes}
\alias{tableOrphanCodes}
\title{Format the result of summariseOrphanCodes into a visual table.}
\usage{
tableOrphanCodes(
  result,
  type = "gt",
  header = c("cdm_name", "estimate"),
  conceptId = TRUE,
  standard = TRUE,
  vocabulary = TRUE,
  relationship = TRUE,
  groupColumns = NULL,
  settings = character(),
  excludeColumns = c("result_id", "estimate_type"),
  .options = list()
)
}
\arguments{
\item{result}{A summarised result with results of the type
"orphan_codes".}

\item{type}{Type of desired formatted table, possibilities: "gt",
"flextable", "tibble".}

\item{header}{A vector containing which elements should go into the header
in order. Allowed are: \code{cdm_name}, \code{group}, \code{strata}, \code{additional},
\code{variable}, \code{estimate}, \code{settings}.}

\item{conceptId}{If TRUE concept ids will be displayed.}

\item{standard}{If TRUE a column indicating if the code is standard will be
displayed.}

\item{vocabulary}{If TRUE vocabulary id will be displayed.}

\item{relationship}{If TRUE relationship id will be displayed.}

\item{groupColumns}{Columns to use as group labels. Allowed columns are
\code{cdm_name} and/or \code{codelist_name}.}

\item{settings}{Vector with the settings columns to display.}

\item{excludeColumns}{Columns to drop from the output table.}

\item{.options}{Named list with additional formatting options.
visOmopResults::optionsVisOmopTable() shows allowed arguments and
their default values.}
}
\value{
A table with a formatted version of the summariseOrphanCodes
result.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\dontrun{
cdm <- mockVocabRef("database")
codes <- getCandidateCodes(cdm = cdm,
keywords = "Musculoskeletal disorder",
domains = "Condition",
includeDescendants = FALSE)

orphan_codes <- summariseOrphanCodes(x = list("msk" = codes$concept_id),
cdm = cdm,
domains = "Condition",
standardConcept = "Standard",
searchInSynonyms = FALSE,
searchNonStandard = FALSE,
includeDescendants = TRUE,
includeAncestor = FALSE)

tableOrphanCodes(orphan_codes)

CDMConnector::cdmDisconnect(cdm)
}

}
