% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildAchillesTables.R
\name{buildAchillesTables}
\alias{buildAchillesTables}
\title{Add the achilles tables with specified analyses}
\usage{
buildAchillesTables(cdm, achillesId = NULL)
}
\arguments{
\item{cdm}{A cdm reference via CDMConnector.}

\item{achillesId}{A vector of achilles ids. If NULL default analysis will be
used.}
}
\value{
The cdm_reference object with the achilles tables populated.
}
\description{
If the cdm reference does not contain the achilles tables, this function
will create them for the analyses used by other functions in the package.
}
\examples{
\donttest{
dbName <- "GiBleed"
CDMConnector::requireEunomia(dbName)
con <- duckdb::dbConnect(duckdb::duckdb(), CDMConnector::eunomiaDir(dbName))
cdm <- CDMConnector::cdmFromCon(
  con = con, cdmSchema = "main", writeSchema = "main"
)

cdm <- buildAchillesTables(cdm = cdm)

}
}
