% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pilsecond.R
\name{pilsecond}
\alias{pilsecond}
\alias{dpilsecond}
\alias{ppilsecond}
\alias{qpilsecond}
\title{prior-informed Lambda second distribution.}
\usage{
ppilsecond(delta, n, d, r) 
dpilsecond(delta, n, d, r) 
qpilsecond(p,     n, d, r)
}
\arguments{
\item{delta}{the parameter of the population whose probability is to assess;}

\item{n}{the sample size n}

\item{d}{the observed d_p of the sample;}

\item{r}{the sample correlation}

\item{p}{the probability from which a quantile is requested}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{     The probability or quantile of a prior-informed Lambda'' distribution.
}\if{html}{\out{</div>}}
}
\description{
This distribution extend the lambda second distribution introduced in
\insertCite{c22b;textual}{CohensdpLibrary} as the exact solution to the predictive
distribution of the Cohen's dp in repeated-measure when the population correlation is known.
A more elegant notation was provided in \insertCite{l22;textual}{CohensdpLibrary}.
The prior-informed lambda prime is a bayesian extension to the lambda prime distribution
in the case where the population rho is not known. It is then replaced by a prior
which indicates the probability of a certain rho given the observed correlation r.
}
\details{
pilsecond are {p,d,q} functions that compute the prior-informed Lambda-second (L") distribution. This
distribution is an generalization of the lambda-prime distribution
\insertCite{l99}{CohensdpLibrary}. It can take up to two seconds to compute.

Note: the parameters are the raw sample size n, the observed Cohen's dp, and the
sample correlation r. All the scaling required are performed within the functions (and so
you do not provide degrees of freedom). This is henceforth not a generic lambda-second
distribution, but a lambda-second custom-tailored  for the problem of standardized mean
difference.
}
\examples{
### Note: this distribution can be slow to compute
### dpilsecond(0.25, 9, 0.26, 0.333) # 1.186735
### ppilsecond(0.25, 9, 0.26, 0.333) # 0.5150561
### qpilsecond(0.01, 9, 0.26, 0.333) # -0.7294266

}
\references{
\insertAllCited{}
}
