% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RemoveOverlappingSubjects.R
\name{removeOverlappingSubjects}
\alias{removeOverlappingSubjects}
\title{Remove subjects in cohort that overlap with another cohort}
\usage{
removeOverlappingSubjects(
  connectionDetails = NULL,
  connection = NULL,
  cohortDatabaseSchema,
  cohortId,
  newCohortId,
  cohortsWithSubjectsToRemove,
  offsetCohortStartDate = -99999,
  offsetCohortEndDate = 99999,
  restrictSecondCohortStartBeforeFirstCohortStart = FALSE,
  restrictSecondCohortStartAfterFirstCohortStart = FALSE,
  cohortTable = "cohort",
  purgeConflicts = FALSE,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema")
)
}
\arguments{
\item{connectionDetails}{An object of type \code{connectionDetails} as created using the
\code{\link[DatabaseConnector]{createConnectionDetails}} function in the
DatabaseConnector package. Can be left NULL if \code{connection} is
provided.}

\item{connection}{An object of type \code{connection} as created using the
\code{\link[DatabaseConnector]{connect}} function in the
DatabaseConnector package. Can be left NULL if \code{connectionDetails}
is provided, in which case a new connection will be opened at the start
of the function, and closed when the function finishes.}

\item{cohortDatabaseSchema}{Schema name where your cohort tables reside. Note that for SQL Server,
this should include both the database and schema name, for example
'scratch.dbo'.}

\item{cohortId}{The cohort id of the cohort whose subjects will be removed.}

\item{newCohortId}{The cohort id of the output cohort.}

\item{cohortsWithSubjectsToRemove}{An array of one or more cohorts with subjects to remove from given cohorts.}

\item{offsetCohortStartDate}{(Default = 0) If you want to offset cohort start date, please provide a integer number.}

\item{offsetCohortEndDate}{(Default = 0) If you want to offset cohort start date, please provide a integer number.}

\item{restrictSecondCohortStartBeforeFirstCohortStart}{(Default = FALSE) If TRUE, then the secondCohort's cohort_start_date
should be < firstCohort's cohort_start_date.}

\item{restrictSecondCohortStartAfterFirstCohortStart}{(Default = FALSE) If TRUE, then the secondCohort's cohort_start_date
should be > firstCohort's cohort_start_date.}

\item{cohortTable}{The name of the cohort table.}

\item{purgeConflicts}{If there are conflicts in the target cohort table i.e. the target cohort table
already has records with newCohortId, do you want to purge and replace them
with transformed. By default - it will not be replaced, and an error message is thrown.}

\item{tempEmulationSchema}{Some database platforms like Oracle and Impala do not truly support
temp tables. To emulate temp tables, provide a schema with write
privileges where temp tables can be created.}
}
\value{
Nothing is returned
}
\description{
Remove subjects in cohort that overlap with another cohort. Given a Cohort A, check if the records of
subjects in cohort A overlaps with records for the same subject in cohort B. If there is overlap
then remove all records of that subject from Cohort A.
Overlap is defined as b.cohort_end_date >= a.cohort_start_date AND b.cohort_start_date <= a.cohort_end_date.
The overlap logic maybe offset by using a startDayOffSet (applied on cohort A's cohort_start_date)
and endDayOffSet (applied on Cohort A's cohort_end_date). If while applying offset, the window becomes
such that (a.cohort_start_date + startDayOffSet) > (a.cohort_end_date + endDayOffset) that record is ignored
and thus deleted.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
