% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseCohortTiming.R
\name{summariseCohortTiming}
\alias{summariseCohortTiming}
\title{Summarise timing between entries into cohorts in a cohort table}
\usage{
summariseCohortTiming(
  cohort,
  cohortId = NULL,
  strata = list(),
  restrictToFirstEntry = TRUE,
  estimates = c("min", "q25", "median", "q75", "max", "density"),
  density = lifecycle::deprecated()
)
}
\arguments{
\item{cohort}{A cohort_table object.}

\item{cohortId}{A cohort definition id to restrict by. If NULL, all cohorts
will be included.}

\item{strata}{A list of variables to stratify results. These variables
must have been added as additional columns in the cohort table.}

\item{restrictToFirstEntry}{If TRUE only an individual's first entry per
cohort will be considered. If FALSE all entries per individual will be
considered.}

\item{estimates}{Summary statistics to use when summarising timing.}

\item{density}{deprecated.}
}
\value{
A summary of timing between entries into cohorts in the cohort table.
}
\description{
Summarise timing between entries into cohorts in a cohort table
}
\examples{
\donttest{
library(CohortCharacteristics)
library(dplyr, warn.conflicts = FALSE)

cdm <- mockCohortCharacteristics(numberIndividuals = 100)

summariseCohortTiming(cdm$cohort2) |>
  glimpse()

}

}
