% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_readFactory.R
\name{readLiteral}
\alias{readLiteral}
\title{Read a file literally (all columns as character)}
\usage{
readLiteral(filename, ...)
}
\arguments{
\item{filename}{Path of file to be read}

\item{...}{Passed to \code{read.table}}
}
\value{
data.frame
}
\description{
Read a file literally (all columns as character)
}
\examples{
\dontrun{
df = data.frame(x = c("T", "\%T", "10341"), 
		y = c("F", "f\%t", "431"), 
		z = c("T", "TRUE", "FALSE"))
tmpf = tempfile()
write.table(df, file = tmpf, quote = FALSE, 
		row.names = FALSE, col.names = FALSE)
df1 = readLiteral(file = tmpf)
all(df1 == df)
}

}
\author{
Kaiyin Zhong, Fan Liu
}

