% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{Cartagena_wifi_tbl_df}
\alias{Cartagena_wifi_tbl_df}
\title{Connected Devices in WiFi Zones of Cartagena (Spanish speaking)}
\format{
A tibble with 468 observations and 8 variables:
\describe{
  \item{AÑO}{Year of the record (numeric)}
  \item{MES}{Month of the record (character)}
  \item{CORREGIMIENTO/BARRIO}{Name of the corregimiento or neighborhood (character)}
  \item{ZONA WIFI}{Name of the WiFi zone (character)}
  \item{OTRO}{Number of connected devices categorized as 'Other' (numeric)}
  \item{SMARTPHONE}{Number of connected smartphones (numeric)}
  \item{TABLET}{Number of connected tablets (numeric)}
  \item{PC}{Number of connected PCs (numeric)}
}
}
\source{
Data obtained from GOV.CO Datos Abiertos: \url{https://www.datos.gov.co/Ciencia-Tecnolog-a-e-Innovaci-n/Dispositivos-conectados-en-las-zonas-wifi-del-dist/94zk-4tpe/about_data}
}
\usage{
data(Cartagena_wifi_tbl_df)
}
\description{
This dataset, Cartagena_wifi_tbl_df, is a tibble containing information about
the number of devices connected in the public WiFi zones of the District of Cartagena.
It includes the year, month, corregimiento or neighborhood, WiFi zone, and counts of
connected devices by type (Other, Smartphone, Tablet, PC). The dataset was obtained
from GOV.CO Datos Abiertos, last update on September 23, 2025.
}
\details{
The dataset name has been kept as 'Cartagena_wifi_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
ColombiAPI package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble object. The original content has not
been modified in any way.
}
