% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CommonMean.Copula.R
\name{CommonMean.Copula}
\alias{CommonMean.Copula}
\title{Estimate bivariate common mean vector under copula models}
\usage{
CommonMean.Copula(Y1, Y2, Sigma1, Sigma2, rho, copula = "Clayton")
}
\arguments{
\item{Y1}{Outcome 1}

\item{Y2}{Outcome 2}

\item{Sigma1}{Standard deviation of outcome 1.}

\item{Sigma2}{Standard deviation of outcome 2.}

\item{rho}{Correlation coefficient between outcomes.}

\item{copula}{The copula to be used with possible options \code{"Clayton"}, \code{"FGM"}, and \code{"normal"}.}
}
\value{
\item{Outcome 1}{Outcome 1.}
\item{Outcome 2}{Outcome 2.}
\item{Correlation}{Correlation coefficient between outcomes.}
\item{Sample size}{Sample size.}
\item{Copula}{Selected copula.}
\item{Copula parameter}{Copula parameter.}
\item{Corrected correlation}{Boundary corrected correlations.}
\item{CommonMean 1}{Estimation results of outcome 1.}
\item{CommonMean 2}{Estimation results of outcome 2.}
\item{V}{Covariance matrix of the common mean vector estimate.}
\item{Log-likelihood values}{Fitted log-likelihood values.}
}
\description{
Estimate the common mean vector under copula models with known correlation. A maximum likelihood estimation procedure is employed. See Shih et al. (2019) for details under the Farlie-Gumbel-Morgenstern (FGM) copula.
}
\details{
We apply \code{"optim"} routine to maximize the log-likelihood function. In addition, boundary corrected correlations will be used (Shih et al., 2019).
}
\examples{
library(CommonMean.Copula)
Y1 = c(35,25,30,50,60) # outcome 1
Y2 = c(30,30,50,65,40) # outcome 2
Sigma1 = c(1.3,1.4,1.5,2.0,1.8) # SE of outcome 1
Sigma2 = c(1.7,1.9,2.5,2.2,1.8) # SE of outcome 2
rho = c(0.4,0.7,0.6,0.7,0.6) # correlation between two outcomes
CommonMean.Copula(Y1,Y2,Sigma1,Sigma2,rho) # input
}
\references{
Shih J-H, Konno Y, Chang Y-T, Emura T (2019) Estimation of a common mean vector in bivariate meta-analysis under the FGM copula, Statistics 53(3): 673-95.
}
