% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getParentsStable.R
\name{getParentsStable}
\alias{getParentsStable}
\title{Estimate the connectivity matrix of a causal graph using stability selection.}
\usage{
getParentsStable(X, environment, interventions = NULL, EV = 1,
  nodewise = TRUE, threshold = 0.75, nsim = 100,
  sampleSettings = 1/sqrt(2), sampleObservations = 1/sqrt(2),
  parentsOf = 1:ncol(X), method = c("ICP", "hiddenICP", "backShift", "pc",
  "LINGAM", "ges", "gies", "CAM", "fci", "rfci", "regression", "bivariateANM",
  "bivariateCAM")[1], alpha = 0.1, mode = c("raw", "parental",
  "ancestral")[1], variableSelMat = NULL, excludeTargetInterventions = TRUE,
  onlyObservationalData = FALSE, indexObservationalData = NULL,
  setOptions = list(), verbose = FALSE)
}
\arguments{
\item{X}{A (nxp)-data matrix with n observations of p variables.}

\item{environment}{A vector of length n, where the entry for 
observation i is an index for the environment in which observation i took 
place (simplest case entries \code{1} for observational data and entries
 \code{2} for interventional data of unspecified type). Is required for 
 methods \code{ICP}, \code{hiddenICP}, \code{backShift}.}

\item{interventions}{A optional list of length n. The entry for observation
i is a numeric vector that specifies the variables on which interventions 
happened for observation i (a scalar if an intervention happened on just 
one variable and \code{numeric(0)} if no intervention occured for this 
observation). Is used for method \code{gies} but will generate the vector 
\code{environment} if this is set to \code{NULL} (even though it might 
generate too many different environments for some data so a hand-picked 
vector \code{environment} is preferable). Is also used for \code{ICP} and 
\code{hiddenICP} to exclude interventions on the target variable of 
interest.}

\item{EV}{A bound on the expected number of falsely selected edges.}

\item{nodewise}{If \code{FALSE}, stability selection retains for each 
subsample the largest overall entries in the connectivity matrix. 
If \code{TRUE}, values are ordered row- and node-wise first and then the 
largest entries in each row and column are retained. Error control is 
valid (under exchangeability assumption) in both cases. The latter setting 
\code{TRUE} is perhaps more robust and is the default.}

\item{threshold}{The empirical selection frequency in (0.5,1) under 
subsampling that needs to be surpassed for an edge to be selected.}

\item{nsim}{The number of resamples for stability selection.}

\item{sampleSettings}{The fraction of different environments to resample 
in each resampling (at least two different environments will be selected so 
the argument is without effect if there are just two different environments 
in total).}

\item{sampleObservations}{The fraction of samples to resample in each 
environment.}

\item{parentsOf}{The variables for which we would like to estimate the 
parents. Default are all variables.}

\item{method}{A string that specfies the method to use. The methods 
\code{pc} (PC-algorithm), \code{LINGAM} (LINGAM), \code{arges} (Adaptively 
restricted greedy equivalence search), \code{ges} 
(Greedy equivalence search), \code{gies} (Greedy interventional equivalence 
search),  \code{fci} (Fast causal inference)  
and \code{rfci} (Really fast causal inference) are imported from the 
package "pcalg" and are documented there in more detail, including the 
additional options that can be supplied via \code{setOptions}. The method 
\code{CAM} (Causal additive models) is documented in the package "CAM" and 
the methods \code{ICP} (Invariant causal prediction), \code{hiddenICP} 
(Invariant causal prediction with hidden variables) are from the package 
"InvariantCausalPrediction". The method \code{backShift} comes from the 
package "backShift". The method \code{mmhc} comes from the 
package "bnlearn". 
Finally, the methods \code{bivariateANM} and 
\code{bivariateCAM} are for now implemented internally but will hopefully 
be part of another package at some point in the near future.}

\item{alpha}{The level at which tests are done. This leads to confidence 
intervals for \code{ICP} and \code{hiddenICP} and is used internally for 
\code{pc} and \code{rfci}.}

\item{mode}{Output type - can be "raw", "parental" or "ancestral". If "raw"
output is the output of the underlying method, without modifications. If "parental"
output described parental relations; if "ancestral" output is casted to ancestral 
relations. #TODO explain further}

\item{variableSelMat}{An optional logical matrix of dimension (pxp). An 
entry \code{TRUE} for entry (i,j) says that variable i should be considered 
as a potential parent for variable j and vice versa for \code{FALSE}. If the 
default value of \code{NULL} is used, all variables will be considered, but 
this can be very slow, especially for methods \code{pc}, \code{ges}, 
\code{gies}, \code{rfci} and \code{CAM}.}

\item{excludeTargetInterventions}{When looking for parents of variable k 
in 1,...,p, set to \code{TRUE} if observations where an intervention on 
variable k occured should be excluded. Default is \code{TRUE}.}

\item{onlyObservationalData}{If set to \code{TRUE}, only observational data 
is used. It will take the index in \code{environment} specified by 
\code{indexObservationalData}. If \code{environment} is \code{NULL}, all 
observations are used. Default is \code{FALSE}.}

\item{indexObservationalData}{Index in \code{environment} that encodes 
observational data. Default is \code{1}.}

\item{setOptions}{A list that can take method-specific options; see the 
individual documentations of the methods for more options and their 
possible values.}

\item{verbose}{If \code{TRUE}, detailed output is provided.}

\item{...}{Parameters to be passed to underlying method's function.}
}
\value{
A sparse matrix, where a 0 entry in (j,k) corresponds to an estimate 
of 'no edge' \code{j} -> \code{parentsOf[k]}. Entries between 0 and 100 
give the selection percentage of this edge over all resamples (set to 0 if
below critical threshold) and all non-zero values are considered as selected
edges.
}
\description{
Estimates the connectivity matrix of a directed causal graph, 
 using various possible methods. Supported methods at the moment are  ARGES,
backShift, bivariateANM, bivariateCAM, CAM, FCI, FCI+, GES, GIES, hiddenICP, 
ICP, LINGAM, MMHC, rankARGES, rankFci, rankGES, rankGIES, rankPC, 
regression, RFCI and PC.
 Uses stability selection to select an appropriate sparseness.
}
\references{
Stability selection (2010):  N. Meinshausen and P. Buhlmann, 
Journal of the Royal Statistical Society: Series B, 72, 417-473
}
\seealso{
\code{\link{getParents}} for the underlying point-estimate of 
the causal graph.
}
\author{
Nicolai Meinshausen \email{meinshausen@stat.math.ethz.ch}, Christina
 Heinze-Deml \email{heinzedeml@stat.math.ethz.ch}
}
\keyword{Causality,}
\keyword{Graph}
\keyword{estimations}
