% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkDatasets.R
\name{checkDatasets}
\alias{checkDatasets}
\title{checkDatasets: assert that the given datasets adhere to the assumptions and requirements of this package
i.e. the data set 'mydata' is a dataframe with 3 columns, named "ID", "Type" and "Score", column "Score" contains numeric data,
and each combination of "ID" and "Type" exists at least once, data set n contains a numerical value for each "Type",
and data set weights contains a numerical value for each "Type" and the sum of all values is equal to 1.}
\usage{
checkDatasets(mydata, n = NULL, weights = NULL)
}
\arguments{
\item{mydata}{A dataframe containing columns ID, Type, Score (numeric)}

\item{n}{A vector containing for each Type the number of score or assessments assessments, e.g. averages, requirements.}

\item{weights}{A vector containing for each Type the weight assigned to it. The sum of weights should be equal to 1.}
}
\value{
A list with the number of Assessments per ID per Type
}
\description{
checkDatasets: assert that the given datasets adhere to the assumptions and requirements of this package
i.e. the data set 'mydata' is a dataframe with 3 columns, named "ID", "Type" and "Score", column "Score" contains numeric data,
and each combination of "ID" and "Type" exists at least once, data set n contains a numerical value for each "Type",
and data set weights contains a numerical value for each "Type" and the sum of all values is equal to 1.
}
\examples{
checkDatasets(mydata, n=c("A"=10, "B"=5, "C"=2), weights=c("A"=1/3,"B"=1/3, "C"=1/3))
}
