% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connectivity_estimation.distributions.R
\encoding{UTF-8}
\name{prob.marked}
\alias{prob.marked}
\title{Returns probability a set of observations correspond to marked individuals}
\usage{
prob.marked(obs, d.unmarked, d.marked, phi = 0.5, p = 1)
}
\arguments{
\item{obs}{A vector of score values for a random sample of (marked and 
unmarked) individuals from the population}

\item{d.unmarked}{A function representing the PDF of unmarked individuals. 
Must be normalized so that it integrates to 1 for the function to work 
properly.}

\item{d.marked}{A function representing the PDF of marked individuals.  Must 
be normalized so that it integrates to 1 for the function to work properly.}

\item{phi}{The fraction of settlers at the destination population that 
originated at the source population. Defaults to 0.5, which would
correspond to an even sample of marked and unmarked individuals.}

\item{p}{Fraction of individuals (i.e., eggs) marked in the source 
population. Defaults to 1.}
}
\value{
A vector of the same size as \code{obs} containing the probability 
  that each individual is marked
}
\description{
This function returns the probability each of a set of observations 
corresponds to a marked individual given the distribution of scores for 
unmarked and marked individuals and the fraction of individuals that are 
marked.
}
\author{
David M. Kaplan \email{dmkaplan2000@gmail.com}
}
\references{
Kaplan DM, Cuif M, Fauvelot C, Vigliola L, Nguyen-Huu T, Tiavouane J and Lett C 
  (in press) Uncertainty in empirical estimates of marine larval connectivity. 
  ICES Journal of Marine Science. doi:10.1093/icesjms/fsw182.
}
\seealso{
See also \code{\link{d.rel.conn.dists.func}},
  \code{\link{optim.rel.conn.dists}}.
}

