% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CC_without_robScore_functions.R
\name{multi_cluster_gen}
\alias{multi_cluster_gen}
\title{Multiple cluster generation}
\usage{
multi_cluster_gen(X, func, rep = 10, param, method = "random")
}
\arguments{
\item{X}{input data Nsample x Nfeatures or a distance matrix}

\item{func}{custom function that accepts \code{X} and a parameter that return a vector of clusterings.
\code{cluster_func <- function(X, param)}}

\item{rep}{number of repeats}

\item{param}{vector of parameters}

\item{method}{method for the choice of k at each repeat \code{c("random", "silhouette")}}
}
\value{
matrix of clusterings Nsample x Nrepeat
}
\description{
Multiple cluster generation
}
\details{
At each repeat, k is selected randomly or based on the best silhouette width from a discrete uniform distribution between range.k[1] and range.k[2].
Then clustering is applied and result is returned.
}
\examples{
X = gaussian_clusters()$X
cluster_func = function(X, k){return(stats::kmeans(X, k)$cluster)}
Clusters = multi_cluster_gen(X, cluster_func, param = c(2,3))


}
