% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FrankFrank.Weibull.MLE.R
\name{FrankFrank.Weibull.MLE}
\alias{FrankFrank.Weibull.MLE}
\title{Parameter estimation based on the Frank copula for serial dependence and the Frank copula for dependent censoring with the Weibull distribuions}
\usage{
FrankFrank.Weibull.MLE(subject, t.event, event, t.death, death,
                              jackknife, plot, GOF, GOF.plot, rep.GOF, digit)
}
\arguments{
\item{subject}{a vector for numbers of subject}

\item{t.event}{a vector for event times}

\item{event}{a vector for event indivator (=1 if recurrent; =0 if censoring)}

\item{t.death}{a vector for death times}

\item{death}{a vector for death indivator (=1 if death; =0 if censoring)}

\item{jackknife}{if TRUE, the jackknife method is used for estimate covariance matrix (default = TRUE)}

\item{plot}{if TRUE, the plots for marginal distributions are shown (default = FALSE)}

\item{GOF}{if TRUE, show the p-values for KS-test and CvM-test}

\item{GOF.plot}{if TRUE, show the model diagnostic plot}

\item{rep.GOF}{repitition number of parametric bootstrap}

\item{digit}{accurate to some decimal places}
}
\value{
A list with the following elements:
\item{Sample_size}{Sample size N}
\item{Case}{Count for event occurences}
\item{r}{Scale parameter for Weib(r, nu_1)}
\item{nu_1}{Shape parameter for Weib(r, nu_1)}
\item{lambda}{Scale parameter for Weib(lambda, nu_2)}
\item{nu_2}{Shape parameter for Weib(lambda, nu_2)}
\item{theta}{Copula parameter for the Frank copula C_theta}
\item{alpha}{Copula parameter for the Frank copula tilde(C)_alpha}
\item{COV}{Asymptotic covariance estimated by the jackknife method}
\item{KS}{Kolmogorov-Smirnov test statistics}
\item{p.KS}{P-values for Kolmogorov-Smirnov tests}
\item{CM}{Cramer-von Mises test statistics}
\item{p.CM}{P-values for Cramer-von Mises tests}
\item{Convergence}{Convergence results for each stage}
\item{Jackknife_error}{Count for error in jackknife repititions}
\item{Log_likelihood}{Log-likelihood values}
}
\description{
Perform two-stage estimation based on the Frank copula C_theta for serial dependence and the Frank copula tilde(C)_alpha for dependent censoring with the marginal disributions Weib(r, nu_1) and Weib(lambda, nu_2). The jackknife method estimates the asymptotic covariance matrix. Parametric bootstrap is applied while doing Kolmogorov-Smirnov tests and Cramer-von Mises test. The guide for using this function shall be explained by Huang (2019).
}
\details{
When jackknife = FALSE, the corresponding values of standard error and confidence interval show NA.
}
\examples{
data = FrankFrank.Weibull.data(r = 1, nu_1 =0.5, theta = 2,
                               lambda = 0.45, nu_2 = 0.5, alpha = 2,
                               N = 300, c = 10, l = 300)

\donttest{
FrankFrank.Weibull.MLE(subject = data$Subject,
                           t.event = data$T_ij, event = data$delta_ij,
                           t.death = data$T_i_star, death = data$delta_i_star,
                           jackknife= TRUE, plot = TRUE)
}

}
\author{
Xinwei Huang
}
