% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lrt_copula.R
\name{lrt_copula}
\alias{lrt_copula}
\title{Likelihood-ratio test for covariate effect(s) in copula models}
\usage{
lrt_copula(model1, model2)
}
\arguments{
\item{model1}{The output of the larger model}

\item{model2}{The output of the smaller model}
}
\value{
the LRT statistics, p value
}
\description{
This function (lrt_copula) is used to perform the likelihood ratio test (LRT) between two nested copula models
}
\examples{
#' # Likelihood-ratio test for "rs2284665" in AREDS data
data(AREDS)
# Fit null model without "rs2284665"
copula2_sp_null <- ic_sp_copula(data = AREDS, copula = "Copula2",
                   l = 0, u = 15, m = 3, r = 3,
                   var_list = c("SevScaleBL"),
                   iter = 300, stepsize = 1e-6, method = "Newton")
# Fit full model
copula2_sp <- ic_sp_copula(data = AREDS, copula = "Copula2",
              l = 0, u = 15, m = 3, r = 3,
              var_list = c("rs2284665","SevScaleBL"),
              iter = 300, stepsize = 1e-6, method = "Newton")
lrt_copula(model1 = copula2_sp, model2 = copula2_sp_null)
}
