% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{fit}
\alias{fit}
\alias{fit,cdtamodel-method}
\title{A function to fit the model.}
\usage{
fit(object, ...)

\S4method{fit}{cdtamodel}(object, data, SID, cores = 3, chains = 3,
  iter = 6000, warmup = 1000, thin = 10, ...)
}
\arguments{
\item{object}{A cdtamodel object created by \link{cdtamodel} function.}

\item{...}{Other optional parameters as specified in \link[rstan]{stan}.}

\item{data}{A data-frame with no missing values containg TP, TN, FP, FN, 'SID' and co-varaiables(if necessary).}

\item{SID}{A string indicating the name of the column with the study identifier.}

\item{cores}{A positive numeric values specifying the number of cores to use to execute parallel sampling. When the hardware has more at least 4 cores,
the default is 3 cores and otherwise 1 core.}

\item{chains}{A positive numeric value specifying the number of chains, default is 3.}

\item{iter}{A positive numeric value specifying the number of iterations per chain. The default is 6000.}

\item{warmup}{A positive numeric value (<iter) specifying the number of iterations to be discarded(burn-in/warm-up). The default is 1000.}

\item{thin}{A positive numeric value specifying the interval in which the samples are stored. The default is 10.}
}
\description{
A function to fit the model.
}

