% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mzXML.R
\name{read.mzXML}
\alias{read.mzXML}
\alias{write.mzXML}
\alias{new.mzXML}
\title{Read and write standard mzXML files.}
\usage{
read.mzXML(filename)

write.mzXML(mzXML, filename, precision = c("32", "64"))

new.mzXML()
}
\arguments{
\item{filename}{The mzXML file name to be read or written.}

\item{mzXML}{The generic mzXML object}

\item{precision}{Either '32' or '64' byte.}
}
\value{
A generic R object of class mzXML for `read.mzXML` and NULL for `write.mzXML`.

Nothing. mzXML object is exported to filename. If it was imported using \code{\link{read.mzXML}} it should contain all previous fields.
}
\description{
`read.mzXML` and `write.mzXML` are copied from the caMassClass 
    package which is no longer actively on CRAN.
}
\details{
The main task of `read.mzXML` and `write.mzXML` functions 
    is to extract and save scan data of mzXML files. In addition attempt is 
    made to keep all other sections of mzXML file as unparsed XML code, so 
    the data can be extracted latter or saved into new mzXML files. Those 
    unparsed sections are stored as XML text.
}
