<p align="center">
	<div align="center">
		<img src="./docs/images/covid-droplet.svg" alt="Logo" style="width:33%">
	</div>
</p>

# Covid19 Wastewater Analysis Package

![GitHub last commit](https://img.shields.io/github/last-commit/UW-Madison-DSI/Covid19Wastewater)
[![GitHub pull requests](https://img.shields.io/github/issues-pr/UW-Madison-DSI/Covid19Wastewater)](https://github.com/UW-Madison-DSI/Covid19Wastewater/pulls)
[![License](https://img.shields.io/badge/license-MIT-green)](https://github.com/UW-Madison-DSI/Covid19Wastewater/blob/main/LICENSE.md)
[![contributors](https://img.shields.io/github/contributors/UW-Madison-DSI/Covid19Wastewater)](https://github.com/UW-Madison-DSI/Covid19Wastewater/graphs/contributors)
![codesize](https://img.shields.io/github/languages/code-size/UW-Madison-DSI/Covid19Wastewater)
![GitHub release (latest by date including pre-releases)](https://img.shields.io/github/v/release/UW-Madison-DSI/Covid19Wastewater?include_prereleases)

This is an R package of utilities to perform wastewater data analysis for pathogenic surveillance and monitoring. 

This project is a collaboration between the University of Wisconsin-Madison [Data Science Institute (DSI)](https://datascience.wisc.edu), the [Wisconsin Department of Health Services (DHS)](https://www.dhs.wisconsin.gov/covid-19/wastewater.htm), and the [State Lab of Hygiene (SLH)](https://www.slh.wisc.edu/environmental/covid-19-wastewater/).

## Getting started

View our [getting started guide](https://github.com/UW-Madison-DSI/Covid19Wastewater/blob/main/docs/getting-started/Starting_Guide.md) to learn more about this R package, or follow the steps below to install, view examples, and get help inside your favorite R interpreter. 

### Installation

If you already have devtools installed, you can install the package with
```
devtools::install_github("UW-Madison-DSI/Covid19Wastewater")
```
Otherwise, we have comprehensive instructions [here](https://github.com/UW-Madison-DSI/Covid19Wastewater/blob/main/docs/r-studio/installing-packages.md).

After installation, view our vignettes 
```
vignette(package = "Covid19Wastewater")
```

or get help.
```
help(package = "Covid19Wastewater")
```


### Examples
We've included a set of [instructional examples](https://github.com/UW-Madison-DSI/Covid19Wastewater/blob/main/examples/README.md) to make this package easy to learn and understand.

## Documentation
 
- View the [Getting Started Guide](https://github.com/UW-Madison-DSI/Covid19Wastewater/blob/main/docs/getting-started/Starting_Guide.md).

- View the [API Reference](https://github.com/UW-Madison-DSI/Covid19Wastewater/blob/main/docs/api/api.md).

- View the package vignettes with:

```
vignette(package = "Covid19Wastewater")
```

- Look at all package functionality with:

```
help(package = "Covid19Wastewater")
```

## Package Application 

We applied this package to Covid-19 data from Wisconsin in our analysis repository [here.](https://github.com/UW-Madison-DSI/Covid19-Wastewater-Analysis)

<!-- LICENSE -->
## License

Distributed under the MIT License. See the [license](https://github.com/UW-Madison-DSI/Covid19Wastewater/blob/main/LICENSE.md) for more information.

<!-- Contact -->
## Team
Email:
- Marlin Lee - (~~mailto:mrlee6@wisc.edu~~)

- Abe Megahed - (mailto:amegahed@wisc.edu)

- Kyllan Wunder - (~~mailto:kwunder@wisc.edu~~)

Repos:
- Package Link: [https://github.com/UW-Madison-DSI/Covid19Wastewater](https://github.com/UW-Madison-DSI/Covid19Wastewater)

- Analysis Link: [https://github.com/UW-Madison-DSI/Covid19-Wastewater-Analysis](https://github.com/UW-Madison-DSI/Covid19-Wastewater-Analysis)
