% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/library--data_prep--calculated_tools--build_analysis_DF.R
\name{buildCaseAnalysisDF}
\alias{buildCaseAnalysisDF}
\title{Prep case data into right format}
\usage{
buildCaseAnalysisDF(
  df,
  site_column = site,
  date_column = date,
  case_column = conf_case,
  pop_column = pop
)
}
\arguments{
\item{df}{case dataframe have columns: Date, pop, FirstConfirmed}

\item{site_column}{name of site column}

\item{date_column}{name of date column}

\item{case_column}{name of case column}

\item{pop_column}{name of pop column}
}
\value{
DF with a 7 day rolling sum and a population weighted case column
}
\description{
Prep case data into right format
}
\examples{
data(Case_data, package = "Covid19Wastewater")
data(Pop_data, package = "Covid19Wastewater")
buildCaseAnalysisDF(dplyr::left_join(head(Case_data), Pop_data))
}
