% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop_row_finder.R
\name{crop_row_finder}
\alias{crop_row_finder}
\title{Maps out the crop rows of the image (of a maize field)}
\usage{
crop_row_finder(picture_list, ratio, final_ratio, intensity)
}
\arguments{
\item{picture_list}{The list of rotated images originally from a single image.}

\item{ratio}{The first strict ratio used to identify which rotation has the most vertical crop rows.}

\item{final_ratio}{The less-strict ratio used on the best image after rotations to capture smaller potential crop rows.}

\item{intensity}{The amount of smoothing of the image.}
}
\value{
a list of x coordinates for the image on which the function was applied.
}
\description{
Finds the x coordinates of the crop rows in the image.
}
\details{
This function is a combination of two previous functions \code{\link{best_rotation}} and \code{\link{crop_lines}} to find the best rotation and then map out the x coordinates of the crop rows in the image.
}
\examples{
\donttest{crop_rows <- crop_row_finder(picture_list, 0.5, 0.05, 0.25)}

}
