% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{power.sen}
\alias{power.sen}
\title{Power of sensitivity analysis}
\usage{
power.sen(mu.F = 1/2, sigma.F = sqrt(1/3), d = NULL, mm = c(2, 2, 2),
  gamma = 1, alpha = 0.05, I = 100, approx.method = c("changing.alpha",
  "fixed.alpha"), score.method = c("approximate", "exact"))
}
\arguments{
\item{mu.F}{mean of the signed rank statistic}

\item{sigma.F}{standard deviation of the signed rank statistic}

\item{d}{empirical data used to estimate \code{mu.F} and \code{sigma.F} by jackknife}

\item{mm}{test statistic, either a vector of length 3 or a matrix of three rows where each column corresponds to a U-statistic. Default is the (approximate) Wilcoxon's signed rank test.}

\item{gamma}{target sensitivity level}

\item{alpha}{target significance level}

\item{I}{sample size}

\item{approx.method}{which approximation method to use?}

\item{score.method}{either approximate score or exact score}
}
\value{
power of the sensitivity analysis, possibly a vector if \code{mm} has multiple columns.
}
\description{
Power of sensitivity analysis
}
\details{
If \code{approx.method} is "fixed.alpha", then the significance level \code{alpha} is considered fixed and the corresponding quantile negligible. Otherwise we also use the \code{alpha}-quantile in the approximation formula. For more detail, see the reference.
}
\examples{

power.sen(d = rnorm(100) + 0.5, I = 200, gamma = 2)

## The following code reproduces an example of power analysis in Zhao (2017)
power.sen(0.76, sqrt(0.26), gamma = 2.5, I = 200)
power.sen(0.76, sqrt(0.26), gamma = 2.5, I = 200, approx.method = "fixed.alpha")

}
\references{
Qingyuan Zhao. On sensitivity value of pair-matched observational studies. arXiv 1702.03442, \url{https://arxiv.org/abs/1702.03442}.
}

