/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mutoss.config.ClassConfig;
import org.mutoss.config.Configuration;
import org.mutoss.gui.CrossoverGUI;
import org.mutoss.gui.Design;
import org.mutoss.gui.DesignTable;
import org.mutoss.gui.FillTableWorker;
import org.mutoss.gui.HTMLOutputPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesignSelectionPanel
extends JPanel
implements ListSelectionListener,
ActionListener,
MouseListener {
    DesignTable designTable;
    HTMLOutputPane jta;
    List<Design> designs;
    JCheckBox jcbPackageArchive = new JCheckBox("Designs from package archive");
    JCheckBox jcbCrossdes = new JCheckBox("Designs generated by package crossdes");
    JCheckBox jcbMyDesigns = new JCheckBox("Designs manually entered");
    JCheckBox jcbSearch = new JCheckBox("Designs from previous search runs");
    CrossoverGUI gui;
    JSplitPane pane;
    ClassConfig ac = new ClassConfig(Configuration.getInstance(), DesignSelectionPanel.class);

    public DesignSelectionPanel(CrossoverGUI gui) {
        this.gui = gui;
        this.pane = new JSplitPane(1, new JScrollPane(this.getLeftSide()), this.getRightSide());
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)this.pane, c);
        this.loadDefaults();
    }

    public JPanel getLeftSide() {
        JPanel panel = new JPanel();
        String cols = "5dlu, fill:min:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, fill:min:grow, 5dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        panel.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        panel.add((Component)new JLabel("List of designs:"), cc.xy(2, row));
        this.designTable = new DesignTable(this.gui);
        this.designTable.addMouseListener(this);
        this.designTable.getSelectionModel().addListSelectionListener(this);
        panel.add((Component)new JScrollPane(this.designTable), cc.xy(2, row += 2));
        panel.add((Component)this.jcbPackageArchive, cc.xy(2, row += 2));
        this.jcbPackageArchive.setSelected(true);
        this.jcbPackageArchive.addActionListener(this);
        panel.add((Component)this.jcbCrossdes, cc.xy(2, row += 2));
        this.jcbCrossdes.setSelected(true);
        this.jcbCrossdes.addActionListener(this);
        panel.add((Component)this.jcbMyDesigns, cc.xy(2, row += 2));
        this.jcbMyDesigns.setSelected(true);
        this.jcbMyDesigns.addActionListener(this);
        panel.add((Component)this.jcbSearch, cc.xy(2, row += 2));
        this.jcbSearch.setSelected(true);
        this.jcbSearch.addActionListener(this);
        return panel;
    }

    public JPanel getRightSide() {
        JPanel panel = new JPanel();
        String cols = "5dlu, fill:min:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, fill:min:grow, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        panel.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        panel.add((Component)new JLabel("Selected design:"), cc.xy(2, row));
        this.jta = new HTMLOutputPane(this.gui);
        this.jta.setFont(new Font("Monospaced", 0, 12));
        panel.add((Component)new JScrollPane(this.jta), cc.xy(2, row += 2));
        return panel;
    }

    public void loadDefaults() {
        this.jcbPackageArchive.setSelected(this.ac.getBoolProperty("PackageArchive", true));
        this.jcbCrossdes.setSelected(this.ac.getBoolProperty("Crossdes", true));
        this.jcbMyDesigns.setSelected(this.ac.getBoolProperty("MyDesigns", true));
        this.jcbSearch.setSelected(this.ac.getBoolProperty("Search", true));
    }

    public void saveDefaults() {
        this.ac.setBoolProperty("PackageArchive", this.jcbPackageArchive.isSelected());
        this.ac.setBoolProperty("Crossdes", this.jcbCrossdes.isSelected());
        this.ac.setBoolProperty("MyDesigns", this.jcbMyDesigns.isSelected());
        this.ac.setBoolProperty("Search", this.jcbSearch.isSelected());
    }

    public DesignSelectionPanel(List<Design> designs, CrossoverGUI gui) {
        this(gui);
        this.setDesigns(designs);
    }

    public void setDesigns(List<Design> designs) {
        this.designTable.setDesigns(designs);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int i = this.designTable.getSelectedRow();
        if (i == -1) {
            return;
        }
        Design design = this.designTable.getModel().getDesigns().get(this.designTable.convertRowIndexToModel(i));
        this.jta.showDesign(design);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FillTableWorker worker = new FillTableWorker(this.gui);
        worker.execute();
        this.saveDefaults();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.popup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.popup(e);
    }

    public void popup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            int r = this.designTable.rowAtPoint(e.getPoint());
            JPopupMenu popup = this.makePopupMenu(r);
            popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private JPopupMenu makePopupMenu(int r) {
        JPopupMenu jpm = new JPopupMenu();
        jpm.add(new JMenuItem("Delete"));
        return jpm;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

