% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyt_errbp.R
\name{cyt_errbp}
\alias{cyt_errbp}
\title{Error-bar Plot.}
\usage{
cyt_errbp(
  data,
  group_col = NULL,
  p_lab = FALSE,
  es_lab = FALSE,
  class_symbol = TRUE,
  x_lab = "",
  y_lab = "",
  title = "",
  log2 = FALSE,
  output_file = NULL
)
}
\arguments{
\item{data}{A data frame containing the data for each group. It should
include at least one numeric column for the measurements and a column
specifying the group membership.}

\item{group_col}{Character. The name of the column in \code{data} that
specifies the group membership.}

\item{p_lab}{Logical. If \code{TRUE}, p-values are displayed on the plot.
Default is \code{FALSE}.}

\item{es_lab}{Logical. If \code{TRUE}, effect sizes (SSMD) are displayed on
the plot. Default is \code{FALSE}.}

\item{class_symbol}{Logical. If \code{TRUE}, significance and effect size are
represented using symbolic notation (e.g., *, **, >, <<). If \code{FALSE},
numeric values are used. Default is \code{TRUE}.}

\item{x_lab}{Character. Label for the x-axis. If not provided, defaults
to the name of the \code{group_col} or "Group" if \code{group_col} is \code{NULL}.}

\item{y_lab}{Character. Label for the y-axis. If not provided, defaults
to "Value".}

\item{title}{Character. Title of the plot. If not provided, a default
title is generated based on the measured variables.}

\item{log2}{Logical. If \code{TRUE}, a log2 transformation (with a +1 offset)
is applied to all numeric columns before analysis. Default is \code{FALSE}.}

\item{output_file}{Character. The file path to save the plot as a PDF.
If \code{NULL}, the plot is displayed but not saved. Default is \code{NULL}.}
}
\value{
An error-bar plot (a \code{ggplot} object) is produced and optionally
saved as a PDF. If \code{output_file} is specified, the function returns
returns the \code{ggplot} object.
}
\description{
This function generates an error-bar plot to visually compare different
groups against a designated baseline group. It displays the central
tendency (mean or median) as a bar and overlays error bars to represent
the data's spread (e.g., standard deviation, MAD, or standard error).
The plot can also include p-value and effect size labels (based on SSMD),
presented either as symbols or numeric values, to highlight significant
differences and the magnitude of effects.
}
\details{
The function performs the following steps:
\enumerate{
\item Optionally applies a log2 transformation to numeric data.
\item Determines the baseline group (the first level of \code{group_col}).
\item Calculates summary statistics (sample size, mean, standard
deviation) for each group and each numeric variable.
\item Performs t-tests to compare each group against the baseline
for each numeric variable.
\item Computes effect sizes (SSMD) for each group compared to the
baseline.
\item Generates a faceted error-bar plot, with one facet per
numeric variable.
\item Optionally adds p-value and effect size labels to the plot.
\item Optionally saves the plot as a PDF.
}
}
\examples{
data <- ExampleData1

cyt_errbp(data[,c("Group", "CCL.20.MIP.3A", "IL.10")], group_col = "Group", 
p_lab = TRUE, es_lab = TRUE, class_symbol = TRUE, x_lab = "Cytokines", 
y_lab = "Concentrations in log2 scale", log2 = TRUE)
}
