% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spade.R
\docType{methods}
\name{spade}
\alias{spade}
\alias{spade.bubbles_export,UserSession,SPADE-method}
\alias{spade.bubbles_export}
\alias{spade.bubbles_set,UserSession,SPADE-method}
\alias{spade.bubbles_set}
\alias{spade.bubbles_show,UserSession,SPADE-method}
\alias{spade.bubbles_show}
\alias{spade.copy_results,UserSession,SPADE-method}
\alias{spade.copy_results}
\alias{spade.copy_settings,UserSession,SPADE-method}
\alias{spade.copy_settings}
\alias{spade.delete,UserSession,SPADE-method}
\alias{spade.delete}
\alias{spade.download_all,UserSession,SPADE-method}
\alias{spade.download_all}
\alias{spade.download_clusters_table,UserSession,SPADE-method}
\alias{spade.download_clusters_table}
\alias{spade.download_global_boundaries_table,UserSession,SPADE-method}
\alias{spade.download_global_boundaries_table}
\alias{spade.download_gml,UserSession,SPADE-method}
\alias{spade.download_gml}
\alias{spade.download_layout_table,UserSession,SPADE-method}
\alias{spade.download_layout_table}
\alias{spade.download_statistics_tables,UserSession,SPADE-method}
\alias{spade.download_statistics_tables}
\alias{spade.list,UserSession-method}
\alias{spade.list}
\alias{spade.new,UserSession-method}
\alias{spade.new}
\alias{spade.rename,UserSession,SPADE-method}
\alias{spade.rename}
\alias{spade.run,UserSession,SPADE-method}
\alias{spade.run}
\alias{spade.show,UserSession-method}
\alias{spade.show}
\alias{spade.status,UserSession,SPADE-method}
\alias{spade.status}
\alias{spade.update,UserSession,SPADE-method}
\alias{spade.update}
\title{SPADE Endpoints}
\usage{
\S4method{spade.bubbles_export}{UserSession,SPADE}(UserSession, spade, bubbles,
  output = "default", timeout = UserSession@long_timeout)

\S4method{spade.bubbles_set}{UserSession,SPADE}(UserSession, spade, bubbles,
  output = "default", timeout = UserSession@long_timeout)

\S4method{spade.bubbles_show}{UserSession,SPADE}(UserSession, spade,
  output = "default", timeout = UserSession@short_timeout)

\S4method{spade.copy_results}{UserSession,SPADE}(UserSession, spade,
  output = "default", timeout = UserSession@short_timeout)

\S4method{spade.copy_settings}{UserSession,SPADE}(UserSession, spade,
  output = "default", timeout = UserSession@short_timeout)

\S4method{spade.delete}{UserSession,SPADE}(UserSession, spade,
  timeout = UserSession@short_timeout)

\S4method{spade.download_all}{UserSession,SPADE}(UserSession, spade,
  directory = getwd(), timeout = UserSession@long_timeout)

\S4method{spade.download_clusters_table}{UserSession,SPADE}(UserSession, spade,
  directory = getwd(), timeout = UserSession@long_timeout)


  \S4method{spade.download_global_boundaries_table}{UserSession,SPADE}(UserSession,
  spade, directory = getwd(), timeout = UserSession@long_timeout)

\S4method{spade.download_gml}{UserSession,SPADE}(UserSession, spade,
  directory = getwd(), timeout = UserSession@long_timeout)

\S4method{spade.download_layout_table}{UserSession,SPADE}(UserSession, spade,
  directory = getwd(), timeout = UserSession@long_timeout)

\S4method{spade.download_statistics_tables}{UserSession,SPADE}(UserSession,
  spade, directory = getwd(), timeout = UserSession@long_timeout)

\S4method{spade.list}{UserSession}(UserSession, experiment_id,
  output = "default", timeout = UserSession@short_timeout)

\S4method{spade.new}{UserSession}(UserSession, experiment_id, spade_name,
  timeout = UserSession@long_timeout)

\S4method{spade.rename}{UserSession,SPADE}(UserSession, spade, spade_name,
  timeout = UserSession@short_timeout)

\S4method{spade.run}{UserSession,SPADE}(UserSession, spade,
  output = "default", timeout = UserSession@long_timeout)

\S4method{spade.show}{UserSession}(UserSession, experiment_id, spade_id,
  timeout = UserSession@short_timeout)

\S4method{spade.status}{UserSession,SPADE}(UserSession, spade,
  output = "default", timeout = UserSession@long_timeout)

\S4method{spade.update}{UserSession,SPADE}(UserSession, spade,
  timeout = UserSession@long_timeout)
}
\arguments{
\item{UserSession}{Cytobank UserSession object}

\item{spade}{Cytobank SPADE object}

\item{bubbles}{vector/list of characters representing bubbles within a SPADE analysis, \href{https://support.cytobank.org/hc/en-us/articles/115000600148-Analysis-and-Interpretation-of-SPADE-Results#Consolidate-Similar-Clusters-into-Bubbles}{learn more about SPADE bubbles}}

\item{output}{character representing the output format  \strong{[optional]}\cr
\emph{- spade.list, spade.run, spade.status : \code{("default", "raw")}}}

\item{timeout}{integer representing the request timeout time in seconds  \strong{[optional]}}

\item{directory}{character representing a specific directory (optional ending directory slash), default will be current working directory \strong{\strong{[optional]}}}

\item{experiment_id}{integer representing an \link[=experiments]{experiment} ID}

\item{spade_name}{character representing a new SPADE name}

\item{spade_id}{integer representing a SPADE ID}
}
\description{
Interact with SPADE advanced analyses using these endpoints.
}
\details{
\code{spade.bubbles_export} Export SPADE advanced analysis bubbles from an experiment to a new experiment.

\code{spade.bubbles_set} Set SPADE advanced analysis bubbles from an experiment.

\code{spade.bubbles_show} Show SPADE advanced analysis bubbles from an experiment.

\code{spade.copy_results} Copy SPADE advanced analysis results from an experiment to a new experiment.

\code{spade.copy_settings} Copy SPADE advanced analysis settings from an experiment.

\code{spade.delete} Delete a SPADE advanced analysis from an experiment.

\code{spade.download_all} Download a SPADE advanced analysis with all data included from an experiment.

\code{spade.download_clusters_table} Download a SPADE advanced analysis global clusters table from an experiment.

\code{spade.download_global_boundaries_table} Download a SPADE advanced analysis global boundaries table from an experiment.

\code{spade.download_gml} Download a SPADE advanced analysis GML from an experiment.

\code{spade.download_layout_table} Download a SPADE advanced analysis layout table from an experiment.

\code{spade.download_statistics_tables} Download a SPADE advanced analysis statistics table from an experiment.

\code{spade.list} List all SPADE advanced analyses from an experiment. Outputs a dataframe [default] or list with all fields present.\cr
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}

\code{spade.new} Create a new SPADE advanced analysis from an experiment and returns a SPADE object.

\code{spade.rename} Rename a SPADE advanced analysis from an experiment and returns a SPADE object.

\code{spade.run} Run a SPADE advanced analysis from an experiment.

\code{spade.show} Show SPADE advanced analysis details from an experiment and returns a SPADE object.

\code{spade.status} Show the status of a SPADE advanced analysis from an experiment.

\code{spade.update} Update a SPADE advanced analysis from an experiment and returns the new SPADE object.
}
\examples{
\donttest{# Authenticate via username/password
cyto_session <- authenticate(site="premium", username="cyril_cytometry", password="cytobank_rocks!")
# Authenticate via auth_token
cyto_session <- authenticate(site="premium", auth_token="my_secret_auth_token")

# cyto_spade refers to a SPADE object that is created from SPADE endpoints
#   examples: spade.new, spade.show (see details section for more)
}
\donttest{spade.bubbles_export(cyto_session, spade=cyto_spade, bubbles=c("bubble1", "bubble2"))
}
\donttest{named_bubble_list_of_node_vectors <- list("bubble_1"=c(1,2,4), "bubble_2"=8, "bubble_4"=c(10,12))
spade.bubbles_set(cyto_session, spade=cyto_spade, bubbles=named_bubble_list_of_node_vectors)
}
\donttest{spade.bubbles_show(cyto_session, spade=cyto_spade)
}
\donttest{spade.copy_results(cyto_session, spade=cyto_spade)
}
\donttest{spade.copy_settings(cyto_session, spade=cyto_spade)
}
\donttest{spade.delete(cyto_session, spade=cyto_spade)
}
\donttest{spade.download_all(cyto_session, spade=cyto_spade, directory="/my/new/download/directory/")
}
\donttest{spade.download_clusters_table(cyto_session, spade=cyto_spade,
  directory="/my/new/download/directory/")
}
\donttest{spade.download_global_boundaries_table(cyto_session,
  spade=cyto_spade, directory="/my/new/download/directory/")
}
\donttest{spade.download_gml(cyto_session, spade=cyto_spade, directory="/my/new/download/directory/")
}
\donttest{spade.download_layout_table(cyto_session, spade=cyto_spade, directory="/my/new/download/directory/")
}
\donttest{spade.download_statistics_tables(cyto_session, spade=cyto_spade,
  directory="/my/new/download/directory/")
}
\donttest{# Dataframe of all SPADE advanced analyses with all fields present
spade.list(cyto_session, 22)

# Raw list of all SPADE advanced analyses with all fields present
spade.list(cyto_session, 22, output="raw")
}
\donttest{spade.new(cyto_session, 22, spade_name="My new SPADE analysis")
}
\donttest{spade.rename(cyto_session, spade=cyto_spade, spade_name="My updated SPADE name")
}
\donttest{spade.run(cyto_session, spade=cyto_spade)
}
\donttest{spade.show(cyto_session, 22, spade_id=2)
}
\donttest{spade.status(cyto_session, spade=cyto_spade)
}
\donttest{spade.update(cyto_session, spade=cyto_spade)
}
}
