% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowsom.R
\name{flowsom}
\alias{flowsom}
\alias{flowsom.copy_settings,UserSession,FlowSOM-method}
\alias{flowsom.copy_settings}
\alias{flowsom.delete,UserSession,FlowSOM-method}
\alias{flowsom.delete}
\alias{flowsom.download,UserSession,FlowSOM-method}
\alias{flowsom.download}
\alias{flowsom.list,UserSession-method}
\alias{flowsom.list}
\alias{flowsom.new,UserSession-method}
\alias{flowsom.new}
\alias{flowsom.rename,UserSession,FlowSOM-method}
\alias{flowsom.rename}
\alias{flowsom.run,UserSession,FlowSOM-method}
\alias{flowsom.run}
\alias{flowsom.show,UserSession-method}
\alias{flowsom.show}
\alias{flowsom.status,UserSession,FlowSOM-method}
\alias{flowsom.status}
\alias{flowsom.update,UserSession,FlowSOM-method}
\alias{flowsom.update}
\title{FlowSOM Endpoints}
\usage{
\S4method{flowsom.copy_settings}{UserSession,FlowSOM}(
  UserSession,
  flowsom,
  output = "default",
  timeout = UserSession@short_timeout
)

\S4method{flowsom.delete}{UserSession,FlowSOM}(UserSession, flowsom, timeout = UserSession@short_timeout)

\S4method{flowsom.download}{UserSession,FlowSOM}(
  UserSession,
  flowsom,
  directory = getwd(),
  timeout = UserSession@long_timeout
)

\S4method{flowsom.list}{UserSession}(
  UserSession,
  experiment_id,
  output = "default",
  timeout = UserSession@short_timeout
)

\S4method{flowsom.new}{UserSession}(
  UserSession,
  experiment_id,
  flowsom_name,
  timeout = UserSession@long_timeout
)

\S4method{flowsom.rename}{UserSession,FlowSOM}(
  UserSession,
  flowsom,
  flowsom_name,
  timeout = UserSession@short_timeout
)

\S4method{flowsom.run}{UserSession,FlowSOM}(
  UserSession,
  flowsom,
  output = "default",
  timeout = UserSession@long_timeout
)

\S4method{flowsom.show}{UserSession}(
  UserSession,
  experiment_id,
  flowsom_id,
  timeout = UserSession@short_timeout
)

\S4method{flowsom.status}{UserSession,FlowSOM}(
  UserSession,
  flowsom,
  output = "default",
  timeout = UserSession@long_timeout
)

\S4method{flowsom.update}{UserSession,FlowSOM}(UserSession, flowsom, timeout = UserSession@long_timeout)
}
\arguments{
\item{UserSession}{Cytobank UserSession object}

\item{flowsom}{Cytobank FlowSOM object}

\item{output}{character representing the output format  \strong{[optional]}\cr
\emph{- flowsom.list, flowsom.run, flowsom.status : \code{("default", "raw")}}}

\item{timeout}{integer representing the request timeout time in seconds  \strong{[optional]}}

\item{directory}{character representing a specific directory to which the file will be downloaded (optional ending directory slash), if left empty, the default will be the current working directory \strong{[optional]}}

\item{experiment_id}{integer representing an \link[=experiments]{experiment} ID}

\item{flowsom_name}{character representing a new FlowSOM name}

\item{flowsom_id}{integer representing a FlowSOM ID}
}
\description{
Interact with FlowSOM advanced analyses using these endpoints.
}
\details{
\code{flowsom.copy_settings} Copy FlowSOM advanced analysis settings from an experiment and returns a FlowSOM object.

\code{flowsom.delete} Delete a FlowSOM advanced analysis from an experiment.

\code{flowsom.download} Download a FlowSOM analysis from an experiment.

\code{flowsom.list} List all FlowSOM advanced analyses from an experiment. Outputs a dataframe [default] or list with all fields present.\cr
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}

\code{flowsom.new} Create a new FlowSOM advanced analysis from an experiment and returns a FlowSOM object.

\code{flowsom.rename} Rename a FlowSOM advanced analysis from an experiment and returns a FlowSOM object.

\code{flowsom.run} Run a FlowSOM advanced analysis from an experiment.

\code{flowsom.show} Show FlowSOM advanced analysis details from an experiment and returns a FlowSOM object.

\code{flowsom.status} Show the status of a FlowSOM advanced analysis from an experiment.

\code{flowsom.update} Update a FlowSOM advanced analysis from an experiment and returns the new FlowSOM object.
}
\examples{
\dontrun{# Authenticate via username/password
cyto_session <- authenticate(site="premium", username="cyril_cytometry", password="cytobank_rocks!")
# Authenticate via auth_token
cyto_session <- authenticate(site="premium", auth_token="my_secret_auth_token")

# cyto_flowsom refers to a FlowSOM object that is created from FlowSOM endpoints
#   examples: flowsom.new, flowsom.show (see details section for more)
}
\dontrun{flowsom.copy_settings(cyto_session, flowsom=cyto_flowsom)
}
\dontrun{flowsom.delete(cyto_session, flowsom=cyto_flowsom)
}
\dontrun{# Download a FlowSOM analysis to the current working directory
flowsom.download(cyto_session, flowsom)

# Download a FlowSOM analysis to a new directory
flowsom.download(cyto_session, flowsom, directory="/my/new/download/directory/")
}
\dontrun{# Dataframe of all FlowSOM advanced analyses with all fields present
flowsom.list(cyto_session, 22)

# Raw list of all FlowSOM advanced analyses with all fields present
flowsom.list(cyto_session, 22, output="raw")
}
\dontrun{flowsom.new(cyto_session, 22, flowsom_name="My new FlowSOM analysis")
}
\dontrun{flowsom.rename(cyto_session, flowsom=cyto_flowsom, flowsom_name=
"My updated FlowSOM name")
}
\dontrun{flowsom.run(cyto_session, flowsom=cyto_flowsom)
}
\dontrun{flowsom.show(cyto_session, 22, flowsom_id=2)
}
\dontrun{flowsom.status(cyto_session, flowsom=cyto_flowsom)
}
\dontrun{flowsom.update(cyto_session, flowsom=cyto_flowsom)
}
}
